/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickdevices;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.iot1clickdevices.model.ClaimDevicesByClaimCodeRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.DescribeDeviceRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.DescribeDeviceResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.FinalizeDeviceClaimRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.FinalizeDeviceClaimResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.GetDeviceMethodsRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.GetDeviceMethodsResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.InitiateDeviceClaimRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.InitiateDeviceClaimResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.InvokeDeviceMethodRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.InvokeDeviceMethodResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.ListDeviceEventsRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.ListDeviceEventsResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.TagResourceRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.TagResourceResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.UnclaimDeviceRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.UnclaimDeviceResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.UntagResourceRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.UntagResourceResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.UpdateDeviceStateRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.UpdateDeviceStateResponse;

/**
 * Service client for accessing AWS IoT 1-Click Devices Service asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Describes all of the AWS IoT 1-Click device-related API operations for the service. Also provides sample requests,
 * responses, and errors for the supported web services protocols.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Iot1ClickDevicesAsyncClient extends SdkClient {
    String SERVICE_NAME = "iot1click";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "devices.iot1click";

    /**
     * <p>
     * Adds device(s) to your account (i.e., claim one or more devices) if and only if you received a claim code with
     * the device(s).
     * </p>
     *
     * @param claimDevicesByClaimCodeRequest
     * @return A Java Future containing the result of the ClaimDevicesByClaimCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.ClaimDevicesByClaimCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ClaimDevicesByClaimCode"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ClaimDevicesByClaimCodeResponse> claimDevicesByClaimCode(
            ClaimDevicesByClaimCodeRequest claimDevicesByClaimCodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds device(s) to your account (i.e., claim one or more devices) if and only if you received a claim code with
     * the device(s).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ClaimDevicesByClaimCodeRequest.Builder} avoiding
     * the need to create one manually via {@link ClaimDevicesByClaimCodeRequest#builder()}
     * </p>
     *
     * @param claimDevicesByClaimCodeRequest
     *        A {@link Consumer} that will call methods on {@link ClaimDevicesByClaimCodeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ClaimDevicesByClaimCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.ClaimDevicesByClaimCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ClaimDevicesByClaimCode"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ClaimDevicesByClaimCodeResponse> claimDevicesByClaimCode(
            Consumer<ClaimDevicesByClaimCodeRequest.Builder> claimDevicesByClaimCodeRequest) {
        return claimDevicesByClaimCode(ClaimDevicesByClaimCodeRequest.builder().applyMutation(claimDevicesByClaimCodeRequest)
                .build());
    }

    /**
     * <p>
     * Given a device ID, returns a DescribeDeviceResponse object describing the details of the device.
     * </p>
     *
     * @param describeDeviceRequest
     * @return A Java Future containing the result of the DescribeDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/DescribeDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDeviceResponse> describeDevice(DescribeDeviceRequest describeDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Given a device ID, returns a DescribeDeviceResponse object describing the details of the device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeDeviceRequest#builder()}
     * </p>
     *
     * @param describeDeviceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDeviceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/DescribeDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDeviceResponse> describeDevice(Consumer<DescribeDeviceRequest.Builder> describeDeviceRequest) {
        return describeDevice(DescribeDeviceRequest.builder().applyMutation(describeDeviceRequest).build());
    }

    /**
     * <p>
     * Given a device ID, finalizes the claim request for the associated device.
     * </p>
     * <note>
     * <p>
     * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a
     * device of type button, a device event can be published by simply clicking the device.
     * </p>
     * </note>
     *
     * @param finalizeDeviceClaimRequest
     * @return A Java Future containing the result of the FinalizeDeviceClaim operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>PreconditionFailedException 412 response</li>
     *         <li>ResourceConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.FinalizeDeviceClaim
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/FinalizeDeviceClaim" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<FinalizeDeviceClaimResponse> finalizeDeviceClaim(
            FinalizeDeviceClaimRequest finalizeDeviceClaimRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Given a device ID, finalizes the claim request for the associated device.
     * </p>
     * <note>
     * <p>
     * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a
     * device of type button, a device event can be published by simply clicking the device.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FinalizeDeviceClaimRequest.Builder} avoiding the
     * need to create one manually via {@link FinalizeDeviceClaimRequest#builder()}
     * </p>
     *
     * @param finalizeDeviceClaimRequest
     *        A {@link Consumer} that will call methods on {@link FinalizeDeviceClaimRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the FinalizeDeviceClaim operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>PreconditionFailedException 412 response</li>
     *         <li>ResourceConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.FinalizeDeviceClaim
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/FinalizeDeviceClaim" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<FinalizeDeviceClaimResponse> finalizeDeviceClaim(
            Consumer<FinalizeDeviceClaimRequest.Builder> finalizeDeviceClaimRequest) {
        return finalizeDeviceClaim(FinalizeDeviceClaimRequest.builder().applyMutation(finalizeDeviceClaimRequest).build());
    }

    /**
     * <p>
     * Given a device ID, returns the invokable methods associated with the device.
     * </p>
     *
     * @param getDeviceMethodsRequest
     * @return A Java Future containing the result of the GetDeviceMethods operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.GetDeviceMethods
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/GetDeviceMethods" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeviceMethodsResponse> getDeviceMethods(GetDeviceMethodsRequest getDeviceMethodsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Given a device ID, returns the invokable methods associated with the device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceMethodsRequest.Builder} avoiding the need
     * to create one manually via {@link GetDeviceMethodsRequest#builder()}
     * </p>
     *
     * @param getDeviceMethodsRequest
     *        A {@link Consumer} that will call methods on {@link GetDeviceMethodsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDeviceMethods operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.GetDeviceMethods
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/GetDeviceMethods" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDeviceMethodsResponse> getDeviceMethods(
            Consumer<GetDeviceMethodsRequest.Builder> getDeviceMethodsRequest) {
        return getDeviceMethods(GetDeviceMethodsRequest.builder().applyMutation(getDeviceMethodsRequest).build());
    }

    /**
     * <p>
     * Given a device ID, initiates a claim request for the associated device.
     * </p>
     * <note>
     * <p>
     * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a
     * device of type button, a device event can be published by simply clicking the device.
     * </p>
     * </note>
     *
     * @param initiateDeviceClaimRequest
     * @return A Java Future containing the result of the InitiateDeviceClaim operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>ResourceConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.InitiateDeviceClaim
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/InitiateDeviceClaim" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<InitiateDeviceClaimResponse> initiateDeviceClaim(
            InitiateDeviceClaimRequest initiateDeviceClaimRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Given a device ID, initiates a claim request for the associated device.
     * </p>
     * <note>
     * <p>
     * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a
     * device of type button, a device event can be published by simply clicking the device.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InitiateDeviceClaimRequest.Builder} avoiding the
     * need to create one manually via {@link InitiateDeviceClaimRequest#builder()}
     * </p>
     *
     * @param initiateDeviceClaimRequest
     *        A {@link Consumer} that will call methods on {@link InitiateDeviceClaimRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the InitiateDeviceClaim operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>ResourceConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.InitiateDeviceClaim
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/InitiateDeviceClaim" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<InitiateDeviceClaimResponse> initiateDeviceClaim(
            Consumer<InitiateDeviceClaimRequest.Builder> initiateDeviceClaimRequest) {
        return initiateDeviceClaim(InitiateDeviceClaimRequest.builder().applyMutation(initiateDeviceClaimRequest).build());
    }

    /**
     * <p>
     * Given a device ID, issues a request to invoke a named device method (with possible parameters). See the
     * "Example POST" code snippet below.
     * </p>
     *
     * @param invokeDeviceMethodRequest
     * @return A Java Future containing the result of the InvokeDeviceMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>PreconditionFailedException 412 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>RangeNotSatisfiableException 416 response</li>
     *         <li>ResourceConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.InvokeDeviceMethod
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/InvokeDeviceMethod" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<InvokeDeviceMethodResponse> invokeDeviceMethod(InvokeDeviceMethodRequest invokeDeviceMethodRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Given a device ID, issues a request to invoke a named device method (with possible parameters). See the
     * "Example POST" code snippet below.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeDeviceMethodRequest.Builder} avoiding the
     * need to create one manually via {@link InvokeDeviceMethodRequest#builder()}
     * </p>
     *
     * @param invokeDeviceMethodRequest
     *        A {@link Consumer} that will call methods on {@link InvokeDeviceMethodRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the InvokeDeviceMethod operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>PreconditionFailedException 412 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>RangeNotSatisfiableException 416 response</li>
     *         <li>ResourceConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.InvokeDeviceMethod
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/InvokeDeviceMethod" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<InvokeDeviceMethodResponse> invokeDeviceMethod(
            Consumer<InvokeDeviceMethodRequest.Builder> invokeDeviceMethodRequest) {
        return invokeDeviceMethod(InvokeDeviceMethodRequest.builder().applyMutation(invokeDeviceMethodRequest).build());
    }

    /**
     * <p>
     * Using a device ID, returns a DeviceEventsResponse object containing an array of events for the device.
     * </p>
     *
     * @param listDeviceEventsRequest
     * @return A Java Future containing the result of the ListDeviceEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>RangeNotSatisfiableException 416 response</li>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.ListDeviceEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ListDeviceEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDeviceEventsResponse> listDeviceEvents(ListDeviceEventsRequest listDeviceEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Using a device ID, returns a DeviceEventsResponse object containing an array of events for the device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceEventsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeviceEventsRequest#builder()}
     * </p>
     *
     * @param listDeviceEventsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeviceEventsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDeviceEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>RangeNotSatisfiableException 416 response</li>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.ListDeviceEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ListDeviceEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDeviceEventsResponse> listDeviceEvents(
            Consumer<ListDeviceEventsRequest.Builder> listDeviceEventsRequest) {
        return listDeviceEvents(ListDeviceEventsRequest.builder().applyMutation(listDeviceEventsRequest).build());
    }

    /**
     * <p>
     * Lists the 1-Click compatible devices associated with your AWS account.
     * </p>
     *
     * @param listDevicesRequest
     * @return A Java Future containing the result of the ListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RangeNotSatisfiableException 416 response</li>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDevicesResponse> listDevices(ListDevicesRequest listDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the 1-Click compatible devices associated with your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on {@link ListDevicesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RangeNotSatisfiableException 416 response</li>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDevicesResponse> listDevices(Consumer<ListDevicesRequest.Builder> listDevicesRequest) {
        return listDevices(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * Lists the tags associated with the specified resource ARN.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags associated with the specified resource ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds or updates the tags associated with the resource ARN. See <a
     * href="https://docs.aws.amazon.com/iot-1-click/latest/developerguide/1click-appendix.html#1click-limits">AWS IoT
     * 1-Click Service Limits</a> for the maximum number of tags allowed per resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates the tags associated with the resource ARN. See <a
     * href="https://docs.aws.amazon.com/iot-1-click/latest/developerguide/1click-appendix.html#1click-limits">AWS IoT
     * 1-Click Service Limits</a> for the maximum number of tags allowed per resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Disassociates a device from your AWS account using its device ID.
     * </p>
     *
     * @param unclaimDeviceRequest
     * @return A Java Future containing the result of the UnclaimDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.UnclaimDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/UnclaimDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UnclaimDeviceResponse> unclaimDevice(UnclaimDeviceRequest unclaimDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a device from your AWS account using its device ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnclaimDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link UnclaimDeviceRequest#builder()}
     * </p>
     *
     * @param unclaimDeviceRequest
     *        A {@link Consumer} that will call methods on {@link UnclaimDeviceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UnclaimDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.UnclaimDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/UnclaimDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UnclaimDeviceResponse> unclaimDevice(Consumer<UnclaimDeviceRequest.Builder> unclaimDeviceRequest) {
        return unclaimDevice(UnclaimDeviceRequest.builder().applyMutation(unclaimDeviceRequest).build());
    }

    /**
     * <p>
     * Using tag keys, deletes the tags (key/value pairs) associated with the specified resource ARN.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Using tag keys, deletes the tags (key/value pairs) associated with the specified resource ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Using a Boolean value (true or false), this operation enables or disables the device given a device ID.
     * </p>
     *
     * @param updateDeviceStateRequest
     * @return A Java Future containing the result of the UpdateDeviceState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.UpdateDeviceState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/UpdateDeviceState" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDeviceStateResponse> updateDeviceState(UpdateDeviceStateRequest updateDeviceStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Using a Boolean value (true or false), this operation enables or disables the device given a device ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeviceStateRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDeviceStateRequest#builder()}
     * </p>
     *
     * @param updateDeviceStateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDeviceStateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateDeviceState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException 404 response</li>
     *         <li>InvalidRequestException 400 response</li>
     *         <li>InternalFailureException 500 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>Iot1ClickDevicesException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample Iot1ClickDevicesAsyncClient.UpdateDeviceState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/UpdateDeviceState" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateDeviceStateResponse> updateDeviceState(
            Consumer<UpdateDeviceStateRequest.Builder> updateDeviceStateRequest) {
        return updateDeviceState(UpdateDeviceStateRequest.builder().applyMutation(updateDeviceStateRequest).build());
    }

    /**
     * Create a {@link Iot1ClickDevicesAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Iot1ClickDevicesAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Iot1ClickDevicesAsyncClient}.
     */
    static Iot1ClickDevicesAsyncClientBuilder builder() {
        return new DefaultIot1ClickDevicesAsyncClientBuilder();
    }
}
