/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickdevices;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.iot1clickdevices.model.ClaimDevicesByClaimCodeRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.ClaimDevicesByClaimCodeResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.DescribeDeviceRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.DescribeDeviceResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.FinalizeDeviceClaimRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.FinalizeDeviceClaimResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.ForbiddenException;
import software.amazon.awssdk.services.iot1clickdevices.model.GetDeviceMethodsRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.GetDeviceMethodsResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.InitiateDeviceClaimRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.InitiateDeviceClaimResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.InternalFailureException;
import software.amazon.awssdk.services.iot1clickdevices.model.InvalidRequestException;
import software.amazon.awssdk.services.iot1clickdevices.model.InvokeDeviceMethodRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.InvokeDeviceMethodResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.Iot1ClickDevicesException;
import software.amazon.awssdk.services.iot1clickdevices.model.ListDeviceEventsRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.ListDeviceEventsResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.PreconditionFailedException;
import software.amazon.awssdk.services.iot1clickdevices.model.RangeNotSatisfiableException;
import software.amazon.awssdk.services.iot1clickdevices.model.ResourceConflictException;
import software.amazon.awssdk.services.iot1clickdevices.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iot1clickdevices.model.TagResourceRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.TagResourceResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.UnclaimDeviceRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.UnclaimDeviceResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.UntagResourceRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.UntagResourceResponse;
import software.amazon.awssdk.services.iot1clickdevices.model.UpdateDeviceStateRequest;
import software.amazon.awssdk.services.iot1clickdevices.model.UpdateDeviceStateResponse;

/**
 * Service client for accessing AWS IoT 1-Click Devices Service. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Describes all of the AWS IoT 1-Click device-related API operations for the service. Also provides sample requests,
 * responses, and errors for the supported web services protocols.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Iot1ClickDevicesClient extends AwsClient {
    String SERVICE_NAME = "iot1click";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "devices.iot1click";

    /**
     * <p>
     * Adds device(s) to your account (i.e., claim one or more devices) if and only if you received a claim code with
     * the device(s).
     * </p>
     *
     * @param claimDevicesByClaimCodeRequest
     * @return Result of the ClaimDevicesByClaimCode operation returned by the service.
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.ClaimDevicesByClaimCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ClaimDevicesByClaimCode"
     *      target="_top">AWS API Documentation</a>
     */
    default ClaimDevicesByClaimCodeResponse claimDevicesByClaimCode(ClaimDevicesByClaimCodeRequest claimDevicesByClaimCodeRequest)
            throws InvalidRequestException, InternalFailureException, ForbiddenException, AwsServiceException,
            SdkClientException, Iot1ClickDevicesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds device(s) to your account (i.e., claim one or more devices) if and only if you received a claim code with
     * the device(s).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ClaimDevicesByClaimCodeRequest.Builder} avoiding
     * the need to create one manually via {@link ClaimDevicesByClaimCodeRequest#builder()}
     * </p>
     *
     * @param claimDevicesByClaimCodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot1clickdevices.model.ClaimDevicesByClaimCodeRequest.Builder} to
     *        create a request.
     * @return Result of the ClaimDevicesByClaimCode operation returned by the service.
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws ForbiddenException
     *         403 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.ClaimDevicesByClaimCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ClaimDevicesByClaimCode"
     *      target="_top">AWS API Documentation</a>
     */
    default ClaimDevicesByClaimCodeResponse claimDevicesByClaimCode(
            Consumer<ClaimDevicesByClaimCodeRequest.Builder> claimDevicesByClaimCodeRequest) throws InvalidRequestException,
            InternalFailureException, ForbiddenException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        return claimDevicesByClaimCode(ClaimDevicesByClaimCodeRequest.builder().applyMutation(claimDevicesByClaimCodeRequest)
                .build());
    }

    /**
     * <p>
     * Given a device ID, returns a DescribeDeviceResponse object describing the details of the device.
     * </p>
     *
     * @param describeDeviceRequest
     * @return Result of the DescribeDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/DescribeDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDeviceResponse describeDevice(DescribeDeviceRequest describeDeviceRequest) throws ResourceNotFoundException,
            InvalidRequestException, InternalFailureException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Given a device ID, returns a DescribeDeviceResponse object describing the details of the device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeDeviceRequest#builder()}
     * </p>
     *
     * @param describeDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot1clickdevices.model.DescribeDeviceRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/DescribeDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDeviceResponse describeDevice(Consumer<DescribeDeviceRequest.Builder> describeDeviceRequest)
            throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, AwsServiceException,
            SdkClientException, Iot1ClickDevicesException {
        return describeDevice(DescribeDeviceRequest.builder().applyMutation(describeDeviceRequest).build());
    }

    /**
     * <p>
     * Given a device ID, finalizes the claim request for the associated device.
     * </p>
     * <note>
     * <p>
     * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a
     * device of type button, a device event can be published by simply clicking the device.
     * </p>
     * </note>
     *
     * @param finalizeDeviceClaimRequest
     * @return Result of the FinalizeDeviceClaim operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws PreconditionFailedException
     *         412 response
     * @throws ResourceConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.FinalizeDeviceClaim
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/FinalizeDeviceClaim" target="_top">AWS
     *      API Documentation</a>
     */
    default FinalizeDeviceClaimResponse finalizeDeviceClaim(FinalizeDeviceClaimRequest finalizeDeviceClaimRequest)
            throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, PreconditionFailedException,
            ResourceConflictException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Given a device ID, finalizes the claim request for the associated device.
     * </p>
     * <note>
     * <p>
     * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a
     * device of type button, a device event can be published by simply clicking the device.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FinalizeDeviceClaimRequest.Builder} avoiding the
     * need to create one manually via {@link FinalizeDeviceClaimRequest#builder()}
     * </p>
     *
     * @param finalizeDeviceClaimRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot1clickdevices.model.FinalizeDeviceClaimRequest.Builder} to
     *        create a request.
     * @return Result of the FinalizeDeviceClaim operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws PreconditionFailedException
     *         412 response
     * @throws ResourceConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.FinalizeDeviceClaim
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/FinalizeDeviceClaim" target="_top">AWS
     *      API Documentation</a>
     */
    default FinalizeDeviceClaimResponse finalizeDeviceClaim(
            Consumer<FinalizeDeviceClaimRequest.Builder> finalizeDeviceClaimRequest) throws ResourceNotFoundException,
            InvalidRequestException, InternalFailureException, PreconditionFailedException, ResourceConflictException,
            AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        return finalizeDeviceClaim(FinalizeDeviceClaimRequest.builder().applyMutation(finalizeDeviceClaimRequest).build());
    }

    /**
     * <p>
     * Given a device ID, returns the invokable methods associated with the device.
     * </p>
     *
     * @param getDeviceMethodsRequest
     * @return Result of the GetDeviceMethods operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.GetDeviceMethods
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/GetDeviceMethods" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDeviceMethodsResponse getDeviceMethods(GetDeviceMethodsRequest getDeviceMethodsRequest)
            throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, AwsServiceException,
            SdkClientException, Iot1ClickDevicesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Given a device ID, returns the invokable methods associated with the device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeviceMethodsRequest.Builder} avoiding the need
     * to create one manually via {@link GetDeviceMethodsRequest#builder()}
     * </p>
     *
     * @param getDeviceMethodsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot1clickdevices.model.GetDeviceMethodsRequest.Builder} to create a
     *        request.
     * @return Result of the GetDeviceMethods operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.GetDeviceMethods
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/GetDeviceMethods" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDeviceMethodsResponse getDeviceMethods(Consumer<GetDeviceMethodsRequest.Builder> getDeviceMethodsRequest)
            throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, AwsServiceException,
            SdkClientException, Iot1ClickDevicesException {
        return getDeviceMethods(GetDeviceMethodsRequest.builder().applyMutation(getDeviceMethodsRequest).build());
    }

    /**
     * <p>
     * Given a device ID, initiates a claim request for the associated device.
     * </p>
     * <note>
     * <p>
     * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a
     * device of type button, a device event can be published by simply clicking the device.
     * </p>
     * </note>
     *
     * @param initiateDeviceClaimRequest
     * @return Result of the InitiateDeviceClaim operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws ResourceConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.InitiateDeviceClaim
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/InitiateDeviceClaim" target="_top">AWS
     *      API Documentation</a>
     */
    default InitiateDeviceClaimResponse initiateDeviceClaim(InitiateDeviceClaimRequest initiateDeviceClaimRequest)
            throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, ResourceConflictException,
            AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Given a device ID, initiates a claim request for the associated device.
     * </p>
     * <note>
     * <p>
     * Claiming a device consists of initiating a claim, then publishing a device event, and finalizing the claim. For a
     * device of type button, a device event can be published by simply clicking the device.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InitiateDeviceClaimRequest.Builder} avoiding the
     * need to create one manually via {@link InitiateDeviceClaimRequest#builder()}
     * </p>
     *
     * @param initiateDeviceClaimRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot1clickdevices.model.InitiateDeviceClaimRequest.Builder} to
     *        create a request.
     * @return Result of the InitiateDeviceClaim operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws ResourceConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.InitiateDeviceClaim
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/InitiateDeviceClaim" target="_top">AWS
     *      API Documentation</a>
     */
    default InitiateDeviceClaimResponse initiateDeviceClaim(
            Consumer<InitiateDeviceClaimRequest.Builder> initiateDeviceClaimRequest) throws ResourceNotFoundException,
            InvalidRequestException, InternalFailureException, ResourceConflictException, AwsServiceException,
            SdkClientException, Iot1ClickDevicesException {
        return initiateDeviceClaim(InitiateDeviceClaimRequest.builder().applyMutation(initiateDeviceClaimRequest).build());
    }

    /**
     * <p>
     * Given a device ID, issues a request to invoke a named device method (with possible parameters). See the
     * "Example POST" code snippet below.
     * </p>
     *
     * @param invokeDeviceMethodRequest
     * @return Result of the InvokeDeviceMethod operation returned by the service.
     * @throws InvalidRequestException
     *         400 response
     * @throws PreconditionFailedException
     *         412 response
     * @throws InternalFailureException
     *         500 response
     * @throws ResourceNotFoundException
     *         404 response
     * @throws RangeNotSatisfiableException
     *         416 response
     * @throws ResourceConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.InvokeDeviceMethod
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/InvokeDeviceMethod" target="_top">AWS
     *      API Documentation</a>
     */
    default InvokeDeviceMethodResponse invokeDeviceMethod(InvokeDeviceMethodRequest invokeDeviceMethodRequest)
            throws InvalidRequestException, PreconditionFailedException, InternalFailureException, ResourceNotFoundException,
            RangeNotSatisfiableException, ResourceConflictException, AwsServiceException, SdkClientException,
            Iot1ClickDevicesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Given a device ID, issues a request to invoke a named device method (with possible parameters). See the
     * "Example POST" code snippet below.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeDeviceMethodRequest.Builder} avoiding the
     * need to create one manually via {@link InvokeDeviceMethodRequest#builder()}
     * </p>
     *
     * @param invokeDeviceMethodRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot1clickdevices.model.InvokeDeviceMethodRequest.Builder} to create
     *        a request.
     * @return Result of the InvokeDeviceMethod operation returned by the service.
     * @throws InvalidRequestException
     *         400 response
     * @throws PreconditionFailedException
     *         412 response
     * @throws InternalFailureException
     *         500 response
     * @throws ResourceNotFoundException
     *         404 response
     * @throws RangeNotSatisfiableException
     *         416 response
     * @throws ResourceConflictException
     *         409 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.InvokeDeviceMethod
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/InvokeDeviceMethod" target="_top">AWS
     *      API Documentation</a>
     */
    default InvokeDeviceMethodResponse invokeDeviceMethod(Consumer<InvokeDeviceMethodRequest.Builder> invokeDeviceMethodRequest)
            throws InvalidRequestException, PreconditionFailedException, InternalFailureException, ResourceNotFoundException,
            RangeNotSatisfiableException, ResourceConflictException, AwsServiceException, SdkClientException,
            Iot1ClickDevicesException {
        return invokeDeviceMethod(InvokeDeviceMethodRequest.builder().applyMutation(invokeDeviceMethodRequest).build());
    }

    /**
     * <p>
     * Using a device ID, returns a DeviceEventsResponse object containing an array of events for the device.
     * </p>
     *
     * @param listDeviceEventsRequest
     * @return Result of the ListDeviceEvents operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws RangeNotSatisfiableException
     *         416 response
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.ListDeviceEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ListDeviceEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDeviceEventsResponse listDeviceEvents(ListDeviceEventsRequest listDeviceEventsRequest)
            throws ResourceNotFoundException, RangeNotSatisfiableException, InvalidRequestException, InternalFailureException,
            AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Using a device ID, returns a DeviceEventsResponse object containing an array of events for the device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeviceEventsRequest.Builder} avoiding the need
     * to create one manually via {@link ListDeviceEventsRequest#builder()}
     * </p>
     *
     * @param listDeviceEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot1clickdevices.model.ListDeviceEventsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDeviceEvents operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws RangeNotSatisfiableException
     *         416 response
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.ListDeviceEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ListDeviceEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDeviceEventsResponse listDeviceEvents(Consumer<ListDeviceEventsRequest.Builder> listDeviceEventsRequest)
            throws ResourceNotFoundException, RangeNotSatisfiableException, InvalidRequestException, InternalFailureException,
            AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        return listDeviceEvents(ListDeviceEventsRequest.builder().applyMutation(listDeviceEventsRequest).build());
    }

    /**
     * <p>
     * Lists the 1-Click compatible devices associated with your AWS account.
     * </p>
     *
     * @param listDevicesRequest
     * @return Result of the ListDevices operation returned by the service.
     * @throws RangeNotSatisfiableException
     *         416 response
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesResponse listDevices(ListDevicesRequest listDevicesRequest) throws RangeNotSatisfiableException,
            InvalidRequestException, InternalFailureException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the 1-Click compatible devices associated with your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot1clickdevices.model.ListDevicesRequest.Builder} to create a
     *        request.
     * @return Result of the ListDevices operation returned by the service.
     * @throws RangeNotSatisfiableException
     *         416 response
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ListDevices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDevicesResponse listDevices(Consumer<ListDevicesRequest.Builder> listDevicesRequest)
            throws RangeNotSatisfiableException, InvalidRequestException, InternalFailureException, AwsServiceException,
            SdkClientException, Iot1ClickDevicesException {
        return listDevices(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * Lists the tags associated with the specified resource ARN.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws InternalFailureException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InternalFailureException, AwsServiceException, SdkClientException,
            Iot1ClickDevicesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags associated with the specified resource ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot1clickdevices.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws InternalFailureException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            InternalFailureException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds or updates the tags associated with the resource ARN. See <a
     * href="https://docs.aws.amazon.com/iot-1-click/latest/developerguide/1click-appendix.html#1click-limits">AWS IoT
     * 1-Click Service Limits</a> for the maximum number of tags allowed per resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            InvalidRequestException, InternalFailureException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates the tags associated with the resource ARN. See <a
     * href="https://docs.aws.amazon.com/iot-1-click/latest/developerguide/1click-appendix.html#1click-limits">AWS IoT
     * 1-Click Service Limits</a> for the maximum number of tags allowed per resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot1clickdevices.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, AwsServiceException,
            SdkClientException, Iot1ClickDevicesException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Disassociates a device from your AWS account using its device ID.
     * </p>
     *
     * @param unclaimDeviceRequest
     * @return Result of the UnclaimDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.UnclaimDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/UnclaimDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default UnclaimDeviceResponse unclaimDevice(UnclaimDeviceRequest unclaimDeviceRequest) throws ResourceNotFoundException,
            InvalidRequestException, InternalFailureException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a device from your AWS account using its device ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnclaimDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link UnclaimDeviceRequest#builder()}
     * </p>
     *
     * @param unclaimDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot1clickdevices.model.UnclaimDeviceRequest.Builder} to create a
     *        request.
     * @return Result of the UnclaimDevice operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.UnclaimDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/UnclaimDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default UnclaimDeviceResponse unclaimDevice(Consumer<UnclaimDeviceRequest.Builder> unclaimDeviceRequest)
            throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, AwsServiceException,
            SdkClientException, Iot1ClickDevicesException {
        return unclaimDevice(UnclaimDeviceRequest.builder().applyMutation(unclaimDeviceRequest).build());
    }

    /**
     * <p>
     * Using tag keys, deletes the tags (key/value pairs) associated with the specified resource ARN.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InvalidRequestException, InternalFailureException, AwsServiceException, SdkClientException, Iot1ClickDevicesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Using tag keys, deletes the tags (key/value pairs) associated with the specified resource ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot1clickdevices.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, AwsServiceException,
            SdkClientException, Iot1ClickDevicesException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Using a Boolean value (true or false), this operation enables or disables the device given a device ID.
     * </p>
     *
     * @param updateDeviceStateRequest
     * @return Result of the UpdateDeviceState operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.UpdateDeviceState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/UpdateDeviceState" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDeviceStateResponse updateDeviceState(UpdateDeviceStateRequest updateDeviceStateRequest)
            throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, AwsServiceException,
            SdkClientException, Iot1ClickDevicesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Using a Boolean value (true or false), this operation enables or disables the device given a device ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeviceStateRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDeviceStateRequest#builder()}
     * </p>
     *
     * @param updateDeviceStateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot1clickdevices.model.UpdateDeviceStateRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateDeviceState operation returned by the service.
     * @throws ResourceNotFoundException
     *         404 response
     * @throws InvalidRequestException
     *         400 response
     * @throws InternalFailureException
     *         500 response
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickDevicesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickDevicesClient.UpdateDeviceState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/UpdateDeviceState" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDeviceStateResponse updateDeviceState(Consumer<UpdateDeviceStateRequest.Builder> updateDeviceStateRequest)
            throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, AwsServiceException,
            SdkClientException, Iot1ClickDevicesException {
        return updateDeviceState(UpdateDeviceStateRequest.builder().applyMutation(updateDeviceStateRequest).build());
    }

    /**
     * Create a {@link Iot1ClickDevicesClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Iot1ClickDevicesClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Iot1ClickDevicesClient}.
     */
    static Iot1ClickDevicesClientBuilder builder() {
        return new DefaultIot1ClickDevicesClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default Iot1ClickDevicesServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
