/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickdevices.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClaimDevicesByClaimCodeRequest extends Iot1ClickDevicesRequest implements
        ToCopyableBuilder<ClaimDevicesByClaimCodeRequest.Builder, ClaimDevicesByClaimCodeRequest> {
    private static final SdkField<String> CLAIM_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClaimCode").getter(getter(ClaimDevicesByClaimCodeRequest::claimCode)).setter(setter(Builder::claimCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("claimCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLAIM_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String claimCode;

    private ClaimDevicesByClaimCodeRequest(BuilderImpl builder) {
        super(builder);
        this.claimCode = builder.claimCode;
    }

    /**
     * <p>
     * The claim code, starting with "C-", as provided by the device manufacturer.
     * </p>
     * 
     * @return The claim code, starting with "C-", as provided by the device manufacturer.
     */
    public final String claimCode() {
        return claimCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(claimCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClaimDevicesByClaimCodeRequest)) {
            return false;
        }
        ClaimDevicesByClaimCodeRequest other = (ClaimDevicesByClaimCodeRequest) obj;
        return Objects.equals(claimCode(), other.claimCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClaimDevicesByClaimCodeRequest").add("ClaimCode", claimCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClaimCode":
            return Optional.ofNullable(clazz.cast(claimCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("claimCode", CLAIM_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClaimDevicesByClaimCodeRequest, T> g) {
        return obj -> g.apply((ClaimDevicesByClaimCodeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Iot1ClickDevicesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ClaimDevicesByClaimCodeRequest> {
        /**
         * <p>
         * The claim code, starting with "C-", as provided by the device manufacturer.
         * </p>
         * 
         * @param claimCode
         *        The claim code, starting with "C-", as provided by the device manufacturer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder claimCode(String claimCode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Iot1ClickDevicesRequest.BuilderImpl implements Builder {
        private String claimCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ClaimDevicesByClaimCodeRequest model) {
            super(model);
            claimCode(model.claimCode);
        }

        public final String getClaimCode() {
            return claimCode;
        }

        public final void setClaimCode(String claimCode) {
            this.claimCode = claimCode;
        }

        @Override
        public final Builder claimCode(String claimCode) {
            this.claimCode = claimCode;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ClaimDevicesByClaimCodeRequest build() {
            return new ClaimDevicesByClaimCodeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
