/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickdevices.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDeviceResponse extends Iot1ClickDevicesResponse implements
        ToCopyableBuilder<DescribeDeviceResponse.Builder, DescribeDeviceResponse> {
    private static final SdkField<DeviceDescription> DEVICE_DESCRIPTION_FIELD = SdkField
            .<DeviceDescription> builder(MarshallingType.SDK_POJO).memberName("DeviceDescription")
            .getter(getter(DescribeDeviceResponse::deviceDescription)).setter(setter(Builder::deviceDescription))
            .constructor(DeviceDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DeviceDescription deviceDescription;

    private DescribeDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.deviceDescription = builder.deviceDescription;
    }

    /**
     * <p>
     * Device details.
     * </p>
     * 
     * @return Device details.
     */
    public final DeviceDescription deviceDescription() {
        return deviceDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeviceResponse)) {
            return false;
        }
        DescribeDeviceResponse other = (DescribeDeviceResponse) obj;
        return Objects.equals(deviceDescription(), other.deviceDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDeviceResponse").add("DeviceDescription", deviceDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceDescription":
            return Optional.ofNullable(clazz.cast(deviceDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("deviceDescription", DEVICE_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeviceResponse, T> g) {
        return obj -> g.apply((DescribeDeviceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Iot1ClickDevicesResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDeviceResponse> {
        /**
         * <p>
         * Device details.
         * </p>
         * 
         * @param deviceDescription
         *        Device details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceDescription(DeviceDescription deviceDescription);

        /**
         * <p>
         * Device details.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceDescription.Builder} avoiding the
         * need to create one manually via {@link DeviceDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceDescription(DeviceDescription)}.
         * 
         * @param deviceDescription
         *        a consumer that will call methods on {@link DeviceDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceDescription(DeviceDescription)
         */
        default Builder deviceDescription(Consumer<DeviceDescription.Builder> deviceDescription) {
            return deviceDescription(DeviceDescription.builder().applyMutation(deviceDescription).build());
        }
    }

    static final class BuilderImpl extends Iot1ClickDevicesResponse.BuilderImpl implements Builder {
        private DeviceDescription deviceDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeviceResponse model) {
            super(model);
            deviceDescription(model.deviceDescription);
        }

        public final DeviceDescription.Builder getDeviceDescription() {
            return deviceDescription != null ? deviceDescription.toBuilder() : null;
        }

        public final void setDeviceDescription(DeviceDescription.BuilderImpl deviceDescription) {
            this.deviceDescription = deviceDescription != null ? deviceDescription.build() : null;
        }

        @Override
        public final Builder deviceDescription(DeviceDescription deviceDescription) {
            this.deviceDescription = deviceDescription;
            return this;
        }

        @Override
        public DescribeDeviceResponse build() {
            return new DescribeDeviceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
