/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickdevices.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeDeviceMethodResponse extends Iot1ClickDevicesResponse implements
        ToCopyableBuilder<InvokeDeviceMethodResponse.Builder, InvokeDeviceMethodResponse> {
    private static final SdkField<String> DEVICE_METHOD_RESPONSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InvokeDeviceMethodResponse::deviceMethodResponse)).setter(setter(Builder::deviceMethodResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceMethodResponse").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_METHOD_RESPONSE_FIELD));

    private final String deviceMethodResponse;

    private InvokeDeviceMethodResponse(BuilderImpl builder) {
        super(builder);
        this.deviceMethodResponse = builder.deviceMethodResponse;
    }

    /**
     * <p>
     * A JSON encoded string containing the device method response.
     * </p>
     * 
     * @return A JSON encoded string containing the device method response.
     */
    public String deviceMethodResponse() {
        return deviceMethodResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceMethodResponse());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeDeviceMethodResponse)) {
            return false;
        }
        InvokeDeviceMethodResponse other = (InvokeDeviceMethodResponse) obj;
        return Objects.equals(deviceMethodResponse(), other.deviceMethodResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InvokeDeviceMethodResponse").add("DeviceMethodResponse", deviceMethodResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceMethodResponse":
            return Optional.ofNullable(clazz.cast(deviceMethodResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeDeviceMethodResponse, T> g) {
        return obj -> g.apply((InvokeDeviceMethodResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Iot1ClickDevicesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, InvokeDeviceMethodResponse> {
        /**
         * <p>
         * A JSON encoded string containing the device method response.
         * </p>
         * 
         * @param deviceMethodResponse
         *        A JSON encoded string containing the device method response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceMethodResponse(String deviceMethodResponse);
    }

    static final class BuilderImpl extends Iot1ClickDevicesResponse.BuilderImpl implements Builder {
        private String deviceMethodResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeDeviceMethodResponse model) {
            super(model);
            deviceMethodResponse(model.deviceMethodResponse);
        }

        public final String getDeviceMethodResponse() {
            return deviceMethodResponse;
        }

        @Override
        public final Builder deviceMethodResponse(String deviceMethodResponse) {
            this.deviceMethodResponse = deviceMethodResponse;
            return this;
        }

        public final void setDeviceMethodResponse(String deviceMethodResponse) {
            this.deviceMethodResponse = deviceMethodResponse;
        }

        @Override
        public InvokeDeviceMethodResponse build() {
            return new InvokeDeviceMethodResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
