/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickdevices.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeviceEventsRequest extends Iot1ClickDevicesRequest implements
        ToCopyableBuilder<ListDeviceEventsRequest.Builder, ListDeviceEventsRequest> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDeviceEventsRequest::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("deviceId").build()).build();

    private static final SdkField<Instant> FROM_TIME_STAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListDeviceEventsRequest::fromTimeStamp))
            .setter(setter(Builder::fromTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("fromTimeStamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListDeviceEventsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDeviceEventsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Instant> TO_TIME_STAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListDeviceEventsRequest::toTimeStamp))
            .setter(setter(Builder::toTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("toTimeStamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD,
            FROM_TIME_STAMP_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, TO_TIME_STAMP_FIELD));

    private final String deviceId;

    private final Instant fromTimeStamp;

    private final Integer maxResults;

    private final String nextToken;

    private final Instant toTimeStamp;

    private ListDeviceEventsRequest(BuilderImpl builder) {
        super(builder);
        this.deviceId = builder.deviceId;
        this.fromTimeStamp = builder.fromTimeStamp;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.toTimeStamp = builder.toTimeStamp;
    }

    /**
     * <p>
     * The unique identifier of the device.
     * </p>
     * 
     * @return The unique identifier of the device.
     */
    public String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The start date for the device event query, in ISO8061 format. For example, 2018-03-28T15:45:12.880Z
     * </p>
     * 
     * @return The start date for the device event query, in ISO8061 format. For example, 2018-03-28T15:45:12.880Z
     */
    public Instant fromTimeStamp() {
        return fromTimeStamp;
    }

    /**
     * <p>
     * The maximum number of results to return per request. If not set, a default value of 100 is used.
     * </p>
     * 
     * @return The maximum number of results to return per request. If not set, a default value of 100 is used.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to retrieve the next set of results.
     * </p>
     * 
     * @return The token to retrieve the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The end date for the device event query, in ISO8061 format. For example, 2018-03-28T15:45:12.880Z
     * </p>
     * 
     * @return The end date for the device event query, in ISO8061 format. For example, 2018-03-28T15:45:12.880Z
     */
    public Instant toTimeStamp() {
        return toTimeStamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(fromTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(toTimeStamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceEventsRequest)) {
            return false;
        }
        ListDeviceEventsRequest other = (ListDeviceEventsRequest) obj;
        return Objects.equals(deviceId(), other.deviceId()) && Objects.equals(fromTimeStamp(), other.fromTimeStamp())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(toTimeStamp(), other.toTimeStamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDeviceEventsRequest").add("DeviceId", deviceId()).add("FromTimeStamp", fromTimeStamp())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("ToTimeStamp", toTimeStamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "FromTimeStamp":
            return Optional.ofNullable(clazz.cast(fromTimeStamp()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ToTimeStamp":
            return Optional.ofNullable(clazz.cast(toTimeStamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeviceEventsRequest, T> g) {
        return obj -> g.apply((ListDeviceEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Iot1ClickDevicesRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDeviceEventsRequest> {
        /**
         * <p>
         * The unique identifier of the device.
         * </p>
         * 
         * @param deviceId
         *        The unique identifier of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The start date for the device event query, in ISO8061 format. For example, 2018-03-28T15:45:12.880Z
         * </p>
         * 
         * @param fromTimeStamp
         *        The start date for the device event query, in ISO8061 format. For example, 2018-03-28T15:45:12.880Z
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromTimeStamp(Instant fromTimeStamp);

        /**
         * <p>
         * The maximum number of results to return per request. If not set, a default value of 100 is used.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per request. If not set, a default value of 100 is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The end date for the device event query, in ISO8061 format. For example, 2018-03-28T15:45:12.880Z
         * </p>
         * 
         * @param toTimeStamp
         *        The end date for the device event query, in ISO8061 format. For example, 2018-03-28T15:45:12.880Z
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toTimeStamp(Instant toTimeStamp);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Iot1ClickDevicesRequest.BuilderImpl implements Builder {
        private String deviceId;

        private Instant fromTimeStamp;

        private Integer maxResults;

        private String nextToken;

        private Instant toTimeStamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceEventsRequest model) {
            super(model);
            deviceId(model.deviceId);
            fromTimeStamp(model.fromTimeStamp);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            toTimeStamp(model.toTimeStamp);
        }

        public final String getDeviceId() {
            return deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public final Instant getFromTimeStamp() {
            return fromTimeStamp;
        }

        @Override
        public final Builder fromTimeStamp(Instant fromTimeStamp) {
            this.fromTimeStamp = fromTimeStamp;
            return this;
        }

        public final void setFromTimeStamp(Instant fromTimeStamp) {
            this.fromTimeStamp = fromTimeStamp;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Instant getToTimeStamp() {
            return toTimeStamp;
        }

        @Override
        public final Builder toTimeStamp(Instant toTimeStamp) {
            this.toTimeStamp = toTimeStamp;
            return this;
        }

        public final void setToTimeStamp(Instant toTimeStamp) {
            this.toTimeStamp = toTimeStamp;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDeviceEventsRequest build() {
            return new ListDeviceEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
