/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickprojects.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object describing a project's placement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlacementDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<PlacementDescription.Builder, PlacementDescription> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlacementDescription::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()).build();

    private static final SdkField<String> PLACEMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PlacementDescription::placementName)).setter(setter(Builder::placementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementName").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(PlacementDescription::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(PlacementDescription::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<Instant> UPDATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(PlacementDescription::updatedDate)).setter(setter(Builder::updatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            PLACEMENT_NAME_FIELD, ATTRIBUTES_FIELD, CREATED_DATE_FIELD, UPDATED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String projectName;

    private final String placementName;

    private final Map<String, String> attributes;

    private final Instant createdDate;

    private final Instant updatedDate;

    private PlacementDescription(BuilderImpl builder) {
        this.projectName = builder.projectName;
        this.placementName = builder.placementName;
        this.attributes = builder.attributes;
        this.createdDate = builder.createdDate;
        this.updatedDate = builder.updatedDate;
    }

    /**
     * <p>
     * The name of the project containing the placement.
     * </p>
     * 
     * @return The name of the project containing the placement.
     */
    public String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The name of the placement.
     * </p>
     * 
     * @return The name of the placement.
     */
    public String placementName() {
        return placementName;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The user-defined attributes associated with the placement.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The user-defined attributes associated with the placement.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The date when the placement was initially created, in UNIX epoch time format.
     * </p>
     * 
     * @return The date when the placement was initially created, in UNIX epoch time format.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The date when the placement was last updated, in UNIX epoch time format. If the placement was not updated, then
     * <code>createdDate</code> and <code>updatedDate</code> are the same.
     * </p>
     * 
     * @return The date when the placement was last updated, in UNIX epoch time format. If the placement was not
     *         updated, then <code>createdDate</code> and <code>updatedDate</code> are the same.
     */
    public Instant updatedDate() {
        return updatedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(placementName());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(updatedDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacementDescription)) {
            return false;
        }
        PlacementDescription other = (PlacementDescription) obj;
        return Objects.equals(projectName(), other.projectName()) && Objects.equals(placementName(), other.placementName())
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(updatedDate(), other.updatedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PlacementDescription").add("ProjectName", projectName()).add("PlacementName", placementName())
                .add("Attributes", attributes()).add("CreatedDate", createdDate()).add("UpdatedDate", updatedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "placementName":
            return Optional.ofNullable(clazz.cast(placementName()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "updatedDate":
            return Optional.ofNullable(clazz.cast(updatedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlacementDescription, T> g) {
        return obj -> g.apply((PlacementDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlacementDescription> {
        /**
         * <p>
         * The name of the project containing the placement.
         * </p>
         * 
         * @param projectName
         *        The name of the project containing the placement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The name of the placement.
         * </p>
         * 
         * @param placementName
         *        The name of the placement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementName(String placementName);

        /**
         * <p>
         * The user-defined attributes associated with the placement.
         * </p>
         * 
         * @param attributes
         *        The user-defined attributes associated with the placement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * The date when the placement was initially created, in UNIX epoch time format.
         * </p>
         * 
         * @param createdDate
         *        The date when the placement was initially created, in UNIX epoch time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The date when the placement was last updated, in UNIX epoch time format. If the placement was not updated,
         * then <code>createdDate</code> and <code>updatedDate</code> are the same.
         * </p>
         * 
         * @param updatedDate
         *        The date when the placement was last updated, in UNIX epoch time format. If the placement was not
         *        updated, then <code>createdDate</code> and <code>updatedDate</code> are the same.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedDate(Instant updatedDate);
    }

    static final class BuilderImpl implements Builder {
        private String projectName;

        private String placementName;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private Instant createdDate;

        private Instant updatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(PlacementDescription model) {
            projectName(model.projectName);
            placementName(model.placementName);
            attributes(model.attributes);
            createdDate(model.createdDate);
            updatedDate(model.updatedDate);
        }

        public final String getProjectName() {
            return projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final String getPlacementName() {
            return placementName;
        }

        @Override
        public final Builder placementName(String placementName) {
            this.placementName = placementName;
            return this;
        }

        public final void setPlacementName(String placementName) {
            this.placementName = placementName;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = PlacementAttributeMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = PlacementAttributeMapCopier.copy(attributes);
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getUpdatedDate() {
            return updatedDate;
        }

        @Override
        public final Builder updatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public final void setUpdatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
        }

        @Override
        public PlacementDescription build() {
            return new PlacementDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
