/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickprojects.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateDeviceWithPlacementRequest extends Iot1ClickProjectsRequest implements
        ToCopyableBuilder<AssociateDeviceWithPlacementRequest.Builder, AssociateDeviceWithPlacementRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateDeviceWithPlacementRequest::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()).build();

    private static final SdkField<String> PLACEMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateDeviceWithPlacementRequest::placementName)).setter(setter(Builder::placementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("placementName").build()).build();

    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateDeviceWithPlacementRequest::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceId").build()).build();

    private static final SdkField<String> DEVICE_TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateDeviceWithPlacementRequest::deviceTemplateName)).setter(setter(Builder::deviceTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("deviceTemplateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            PLACEMENT_NAME_FIELD, DEVICE_ID_FIELD, DEVICE_TEMPLATE_NAME_FIELD));

    private final String projectName;

    private final String placementName;

    private final String deviceId;

    private final String deviceTemplateName;

    private AssociateDeviceWithPlacementRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.placementName = builder.placementName;
        this.deviceId = builder.deviceId;
        this.deviceTemplateName = builder.deviceTemplateName;
    }

    /**
     * <p>
     * The name of the project containing the placement in which to associate the device.
     * </p>
     * 
     * @return The name of the project containing the placement in which to associate the device.
     */
    public String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The name of the placement in which to associate the device.
     * </p>
     * 
     * @return The name of the placement in which to associate the device.
     */
    public String placementName() {
        return placementName;
    }

    /**
     * <p>
     * The ID of the physical device to be associated with the given placement in the project. Note that a mandatory 4
     * character prefix is required for all <code>deviceId</code> values.
     * </p>
     * 
     * @return The ID of the physical device to be associated with the given placement in the project. Note that a
     *         mandatory 4 character prefix is required for all <code>deviceId</code> values.
     */
    public String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The device template name to associate with the device ID.
     * </p>
     * 
     * @return The device template name to associate with the device ID.
     */
    public String deviceTemplateName() {
        return deviceTemplateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(placementName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTemplateName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateDeviceWithPlacementRequest)) {
            return false;
        }
        AssociateDeviceWithPlacementRequest other = (AssociateDeviceWithPlacementRequest) obj;
        return Objects.equals(projectName(), other.projectName()) && Objects.equals(placementName(), other.placementName())
                && Objects.equals(deviceId(), other.deviceId())
                && Objects.equals(deviceTemplateName(), other.deviceTemplateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssociateDeviceWithPlacementRequest").add("ProjectName", projectName())
                .add("PlacementName", placementName()).add("DeviceId", deviceId())
                .add("DeviceTemplateName", deviceTemplateName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "placementName":
            return Optional.ofNullable(clazz.cast(placementName()));
        case "deviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "deviceTemplateName":
            return Optional.ofNullable(clazz.cast(deviceTemplateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateDeviceWithPlacementRequest, T> g) {
        return obj -> g.apply((AssociateDeviceWithPlacementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Iot1ClickProjectsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateDeviceWithPlacementRequest> {
        /**
         * <p>
         * The name of the project containing the placement in which to associate the device.
         * </p>
         * 
         * @param projectName
         *        The name of the project containing the placement in which to associate the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The name of the placement in which to associate the device.
         * </p>
         * 
         * @param placementName
         *        The name of the placement in which to associate the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementName(String placementName);

        /**
         * <p>
         * The ID of the physical device to be associated with the given placement in the project. Note that a mandatory
         * 4 character prefix is required for all <code>deviceId</code> values.
         * </p>
         * 
         * @param deviceId
         *        The ID of the physical device to be associated with the given placement in the project. Note that a
         *        mandatory 4 character prefix is required for all <code>deviceId</code> values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The device template name to associate with the device ID.
         * </p>
         * 
         * @param deviceTemplateName
         *        The device template name to associate with the device ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTemplateName(String deviceTemplateName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Iot1ClickProjectsRequest.BuilderImpl implements Builder {
        private String projectName;

        private String placementName;

        private String deviceId;

        private String deviceTemplateName;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateDeviceWithPlacementRequest model) {
            super(model);
            projectName(model.projectName);
            placementName(model.placementName);
            deviceId(model.deviceId);
            deviceTemplateName(model.deviceTemplateName);
        }

        public final String getProjectName() {
            return projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final String getPlacementName() {
            return placementName;
        }

        @Override
        public final Builder placementName(String placementName) {
            this.placementName = placementName;
            return this;
        }

        public final void setPlacementName(String placementName) {
            this.placementName = placementName;
        }

        public final String getDeviceId() {
            return deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public final String getDeviceTemplateName() {
            return deviceTemplateName;
        }

        @Override
        public final Builder deviceTemplateName(String deviceTemplateName) {
            this.deviceTemplateName = deviceTemplateName;
            return this;
        }

        public final void setDeviceTemplateName(String deviceTemplateName) {
            this.deviceTemplateName = deviceTemplateName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateDeviceWithPlacementRequest build() {
            return new AssociateDeviceWithPlacementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
