/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickprojects;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iot1clickprojects.model.AssociateDeviceWithPlacementRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.AssociateDeviceWithPlacementResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.CreatePlacementRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.CreatePlacementResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.CreateProjectRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.CreateProjectResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.DeletePlacementRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.DeletePlacementResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.DeleteProjectRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.DeleteProjectResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.DescribePlacementRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.DescribePlacementResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.DescribeProjectRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.DescribeProjectResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.DisassociateDeviceFromPlacementRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.DisassociateDeviceFromPlacementResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.GetDevicesInPlacementRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.GetDevicesInPlacementResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.InternalFailureException;
import software.amazon.awssdk.services.iot1clickprojects.model.InvalidRequestException;
import software.amazon.awssdk.services.iot1clickprojects.model.Iot1ClickProjectsException;
import software.amazon.awssdk.services.iot1clickprojects.model.Iot1ClickProjectsRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.ResourceConflictException;
import software.amazon.awssdk.services.iot1clickprojects.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iot1clickprojects.model.TagResourceRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.TagResourceResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.TooManyRequestsException;
import software.amazon.awssdk.services.iot1clickprojects.model.UntagResourceRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.UntagResourceResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.UpdatePlacementRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.UpdatePlacementResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.UpdateProjectRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.UpdateProjectResponse;
import software.amazon.awssdk.services.iot1clickprojects.paginators.ListPlacementsIterable;
import software.amazon.awssdk.services.iot1clickprojects.paginators.ListProjectsIterable;
import software.amazon.awssdk.services.iot1clickprojects.transform.AssociateDeviceWithPlacementRequestMarshaller;
import software.amazon.awssdk.services.iot1clickprojects.transform.CreatePlacementRequestMarshaller;
import software.amazon.awssdk.services.iot1clickprojects.transform.CreateProjectRequestMarshaller;
import software.amazon.awssdk.services.iot1clickprojects.transform.DeletePlacementRequestMarshaller;
import software.amazon.awssdk.services.iot1clickprojects.transform.DeleteProjectRequestMarshaller;
import software.amazon.awssdk.services.iot1clickprojects.transform.DescribePlacementRequestMarshaller;
import software.amazon.awssdk.services.iot1clickprojects.transform.DescribeProjectRequestMarshaller;
import software.amazon.awssdk.services.iot1clickprojects.transform.DisassociateDeviceFromPlacementRequestMarshaller;
import software.amazon.awssdk.services.iot1clickprojects.transform.GetDevicesInPlacementRequestMarshaller;
import software.amazon.awssdk.services.iot1clickprojects.transform.ListPlacementsRequestMarshaller;
import software.amazon.awssdk.services.iot1clickprojects.transform.ListProjectsRequestMarshaller;
import software.amazon.awssdk.services.iot1clickprojects.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iot1clickprojects.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iot1clickprojects.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iot1clickprojects.transform.UpdatePlacementRequestMarshaller;
import software.amazon.awssdk.services.iot1clickprojects.transform.UpdateProjectRequestMarshaller;

/**
 * Internal implementation of {@link Iot1ClickProjectsClient}.
 *
 * @see Iot1ClickProjectsClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultIot1ClickProjectsClient implements Iot1ClickProjectsClient {
    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIot1ClickProjectsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Associates a physical device with a placement.
     * </p>
     *
     * @param associateDeviceWithPlacementRequest
     * @return Result of the AssociateDeviceWithPlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceConflictException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.AssociateDeviceWithPlacement
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/AssociateDeviceWithPlacement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateDeviceWithPlacementResponse associateDeviceWithPlacement(
            AssociateDeviceWithPlacementRequest associateDeviceWithPlacementRequest) throws InternalFailureException,
            InvalidRequestException, ResourceConflictException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateDeviceWithPlacementResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateDeviceWithPlacementResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<AssociateDeviceWithPlacementRequest, AssociateDeviceWithPlacementResponse>()
                        .withOperationName("AssociateDeviceWithPlacement").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(associateDeviceWithPlacementRequest)
                        .withMarshaller(new AssociateDeviceWithPlacementRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates an empty placement.
     * </p>
     *
     * @param createPlacementRequest
     * @return Result of the CreatePlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceConflictException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.CreatePlacement
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/CreatePlacement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreatePlacementResponse createPlacement(CreatePlacementRequest createPlacementRequest)
            throws InternalFailureException, InvalidRequestException, ResourceConflictException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, Iot1ClickProjectsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePlacementResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreatePlacementResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreatePlacementRequest, CreatePlacementResponse>()
                .withOperationName("CreatePlacement").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createPlacementRequest)
                .withMarshaller(new CreatePlacementRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates an empty project with a placement template. A project contains zero or more placements that adhere to the
     * placement template defined in the project.
     * </p>
     *
     * @param createProjectRequest
     * @return Result of the CreateProject operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.CreateProject
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/CreateProject"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws InternalFailureException,
            InvalidRequestException, ResourceConflictException, AwsServiceException, SdkClientException,
            Iot1ClickProjectsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateProjectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateProjectRequest, CreateProjectResponse>()
                .withOperationName("CreateProject").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createProjectRequest)
                .withMarshaller(new CreateProjectRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a placement. To delete a placement, it must not have any devices associated with it.
     * </p>
     * <note>
     * <p>
     * When you delete a placement, all associated data becomes irretrievable.
     * </p>
     * </note>
     *
     * @param deletePlacementRequest
     * @return Result of the DeletePlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws TooManyRequestsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.DeletePlacement
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DeletePlacement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeletePlacementResponse deletePlacement(DeletePlacementRequest deletePlacementRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, Iot1ClickProjectsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePlacementResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeletePlacementResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeletePlacementRequest, DeletePlacementResponse>()
                .withOperationName("DeletePlacement").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deletePlacementRequest)
                .withMarshaller(new DeletePlacementRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a project. To delete a project, it must not have any placements associated with it.
     * </p>
     * <note>
     * <p>
     * When you delete a project, all associated data becomes irretrievable.
     * </p>
     * </note>
     *
     * @param deleteProjectRequest
     * @return Result of the DeleteProject operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws TooManyRequestsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.DeleteProject
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DeleteProject"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws InternalFailureException,
            InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteProjectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteProjectRequest, DeleteProjectResponse>()
                .withOperationName("DeleteProject").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteProjectRequest)
                .withMarshaller(new DeleteProjectRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Describes a placement in a project.
     * </p>
     *
     * @param describePlacementRequest
     * @return Result of the DescribePlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.DescribePlacement
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DescribePlacement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePlacementResponse describePlacement(DescribePlacementRequest describePlacementRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePlacementResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribePlacementResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DescribePlacementRequest, DescribePlacementResponse>()
                .withOperationName("DescribePlacement").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describePlacementRequest)
                .withMarshaller(new DescribePlacementRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns an object describing a project.
     * </p>
     *
     * @param describeProjectRequest
     * @return Result of the DescribeProject operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.DescribeProject
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DescribeProject"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeProjectResponse describeProject(DescribeProjectRequest describeProjectRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeProjectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DescribeProjectRequest, DescribeProjectResponse>()
                .withOperationName("DescribeProject").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(describeProjectRequest)
                .withMarshaller(new DescribeProjectRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes a physical device from a placement.
     * </p>
     *
     * @param disassociateDeviceFromPlacementRequest
     * @return Result of the DisassociateDeviceFromPlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws TooManyRequestsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.DisassociateDeviceFromPlacement
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DisassociateDeviceFromPlacement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateDeviceFromPlacementResponse disassociateDeviceFromPlacement(
            DisassociateDeviceFromPlacementRequest disassociateDeviceFromPlacementRequest) throws InternalFailureException,
            InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateDeviceFromPlacementResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateDeviceFromPlacementResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DisassociateDeviceFromPlacementRequest, DisassociateDeviceFromPlacementResponse>()
                        .withOperationName("DisassociateDeviceFromPlacement").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(disassociateDeviceFromPlacementRequest)
                        .withMarshaller(new DisassociateDeviceFromPlacementRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns an object enumerating the devices in a placement.
     * </p>
     *
     * @param getDevicesInPlacementRequest
     * @return Result of the GetDevicesInPlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.GetDevicesInPlacement
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/GetDevicesInPlacement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDevicesInPlacementResponse getDevicesInPlacement(GetDevicesInPlacementRequest getDevicesInPlacementRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDevicesInPlacementResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDevicesInPlacementResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetDevicesInPlacementRequest, GetDevicesInPlacementResponse>()
                .withOperationName("GetDevicesInPlacement").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getDevicesInPlacementRequest)
                .withMarshaller(new GetDevicesInPlacementRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the placement(s) of a project.
     * </p>
     *
     * @param listPlacementsRequest
     * @return Result of the ListPlacements operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.ListPlacements
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListPlacements"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPlacementsResponse listPlacements(ListPlacementsRequest listPlacementsRequest) throws InternalFailureException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Iot1ClickProjectsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPlacementsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListPlacementsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListPlacementsRequest, ListPlacementsResponse>()
                .withOperationName("ListPlacements").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listPlacementsRequest)
                .withMarshaller(new ListPlacementsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the placement(s) of a project.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlacements(software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot1clickprojects.paginators.ListPlacementsIterable responses = client.listPlacementsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot1clickprojects.paginators.ListPlacementsIterable responses = client
     *             .listPlacementsPaginator(request);
     *     for (software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot1clickprojects.paginators.ListPlacementsIterable responses = client.listPlacementsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlacements(software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPlacementsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.ListPlacements
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListPlacements"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPlacementsIterable listPlacementsPaginator(ListPlacementsRequest listPlacementsRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        return new ListPlacementsIterable(this, applyPaginatorUserAgent(listPlacementsRequest));
    }

    /**
     * <p>
     * Lists the AWS IoT 1-Click project(s) associated with your AWS account and region.
     * </p>
     *
     * @param listProjectsRequest
     * @return Result of the ListProjects operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.ListProjects
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListProjects"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListProjectsResponse listProjects(ListProjectsRequest listProjectsRequest) throws InternalFailureException,
            InvalidRequestException, AwsServiceException, SdkClientException, Iot1ClickProjectsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListProjectsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListProjectsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListProjectsRequest, ListProjectsResponse>()
                .withOperationName("ListProjects").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listProjectsRequest)
                .withMarshaller(new ListProjectsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the AWS IoT 1-Click project(s) associated with your AWS account and region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProjects(software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot1clickprojects.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot1clickprojects.paginators.ListProjectsIterable responses = client
     *             .listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot1clickprojects.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @param listProjectsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.ListProjects
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListProjects"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListProjectsIterable listProjectsPaginator(ListProjectsRequest listProjectsRequest) throws InternalFailureException,
            InvalidRequestException, AwsServiceException, SdkClientException, Iot1ClickProjectsException {
        return new ListProjectsIterable(this, applyPaginatorUserAgent(listProjectsRequest));
    }

    /**
     * <p>
     * Lists the tags (metadata key/value pairs) which you have assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates or modifies tags for a resource. Tags are key/value pairs (metadata) that can be used to manage a
     * resource. For more information, see <a
     * href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging Strategies</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalFailureException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Iot1ClickProjectsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                .withOperationName("TagResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes one or more tags (metadata key/value pairs) from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalFailureException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Iot1ClickProjectsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                .withOperationName("UntagResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates a placement with the given attributes. To clear an attribute, pass an empty value (i.e., "").
     * </p>
     *
     * @param updatePlacementRequest
     * @return Result of the UpdatePlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws TooManyRequestsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.UpdatePlacement
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/UpdatePlacement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdatePlacementResponse updatePlacement(UpdatePlacementRequest updatePlacementRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, Iot1ClickProjectsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePlacementResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdatePlacementResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdatePlacementRequest, UpdatePlacementResponse>()
                .withOperationName("UpdatePlacement").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updatePlacementRequest)
                .withMarshaller(new UpdatePlacementRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates a project associated with your AWS account and region. With the exception of device template names, you
     * can pass just the values that need to be updated because the update request will change only the values that are
     * provided. To clear a value, pass the empty string (i.e., <code>""</code>).
     * </p>
     *
     * @param updateProjectRequest
     * @return Result of the UpdateProject operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws TooManyRequestsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.UpdateProject
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/UpdateProject"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateProjectResponse updateProject(UpdateProjectRequest updateProjectRequest) throws InternalFailureException,
            InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateProjectResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateProjectResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateProjectRequest, UpdateProjectResponse>()
                .withOperationName("UpdateProject").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateProjectRequest)
                .withMarshaller(new UpdateProjectRequestMarshaller(protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(Iot1ClickProjectsException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalFailureException")
                                .exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceConflictException")
                                .exceptionBuilderSupplier(ResourceConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(429).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends Iot1ClickProjectsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
