/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot1clickprojects.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot1clickprojects.model.Iot1ClickProjectsResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.PlacementSummary;
import software.amazon.awssdk.services.iot1clickprojects.model.PlacementSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPlacementsResponse
extends Iot1ClickProjectsResponse
implements ToCopyableBuilder<Builder, ListPlacementsResponse> {
    private static final SdkField<List<PlacementSummary>> PLACEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListPlacementsResponse.getter(ListPlacementsResponse::placements)).setter(ListPlacementsResponse.setter(Builder::placements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacementSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPlacementsResponse.getter(ListPlacementsResponse::nextToken)).setter(ListPlacementsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACEMENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<PlacementSummary> placements;
    private final String nextToken;

    private ListPlacementsResponse(BuilderImpl builder) {
        super(builder);
        this.placements = builder.placements;
        this.nextToken = builder.nextToken;
    }

    public boolean hasPlacements() {
        return this.placements != null && !(this.placements instanceof SdkAutoConstructList);
    }

    public List<PlacementSummary> placements() {
        return this.placements;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.placements());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlacementsResponse)) {
            return false;
        }
        ListPlacementsResponse other = (ListPlacementsResponse)((Object)obj);
        return Objects.equals(this.placements(), other.placements()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListPlacementsResponse").add("Placements", this.placements()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "placements": {
                return Optional.ofNullable(clazz.cast(this.placements()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPlacementsResponse, T> g) {
        return obj -> g.apply((ListPlacementsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Iot1ClickProjectsResponse.BuilderImpl
    implements Builder {
        private List<PlacementSummary> placements = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlacementsResponse model) {
            super(model);
            this.placements(model.placements);
            this.nextToken(model.nextToken);
        }

        public final Collection<PlacementSummary.Builder> getPlacements() {
            return this.placements != null ? (Collection)this.placements.stream().map(PlacementSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placements(Collection<PlacementSummary> placements) {
            this.placements = PlacementSummaryListCopier.copy(placements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placements(PlacementSummary ... placements) {
            this.placements(Arrays.asList(placements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placements(Consumer<PlacementSummary.Builder> ... placements) {
            this.placements(Stream.of(placements).map(c -> (PlacementSummary)((PlacementSummary.Builder)PlacementSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlacements(Collection<PlacementSummary.BuilderImpl> placements) {
            this.placements = PlacementSummaryListCopier.copyFromBuilder(placements);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPlacementsResponse build() {
            return new ListPlacementsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Iot1ClickProjectsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPlacementsResponse> {
        public Builder placements(Collection<PlacementSummary> var1);

        public Builder placements(PlacementSummary ... var1);

        public Builder placements(Consumer<PlacementSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

