/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickprojects.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProjectResponse extends Iot1ClickProjectsResponse implements
        ToCopyableBuilder<DescribeProjectResponse.Builder, DescribeProjectResponse> {
    private static final SdkField<ProjectDescription> PROJECT_FIELD = SdkField
            .<ProjectDescription> builder(MarshallingType.SDK_POJO).getter(getter(DescribeProjectResponse::project))
            .setter(setter(Builder::project)).constructor(ProjectDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("project").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_FIELD));

    private final ProjectDescription project;

    private DescribeProjectResponse(BuilderImpl builder) {
        super(builder);
        this.project = builder.project;
    }

    /**
     * <p>
     * An object describing the project.
     * </p>
     * 
     * @return An object describing the project.
     */
    public ProjectDescription project() {
        return project;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(project());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProjectResponse)) {
            return false;
        }
        DescribeProjectResponse other = (DescribeProjectResponse) obj;
        return Objects.equals(project(), other.project());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeProjectResponse").add("Project", project()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "project":
            return Optional.ofNullable(clazz.cast(project()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProjectResponse, T> g) {
        return obj -> g.apply((DescribeProjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Iot1ClickProjectsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeProjectResponse> {
        /**
         * <p>
         * An object describing the project.
         * </p>
         * 
         * @param project
         *        An object describing the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(ProjectDescription project);

        /**
         * <p>
         * An object describing the project.
         * </p>
         * This is a convenience that creates an instance of the {@link ProjectDescription.Builder} avoiding the need to
         * create one manually via {@link ProjectDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProjectDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #project(ProjectDescription)}.
         * 
         * @param project
         *        a consumer that will call methods on {@link ProjectDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #project(ProjectDescription)
         */
        default Builder project(Consumer<ProjectDescription.Builder> project) {
            return project(ProjectDescription.builder().applyMutation(project).build());
        }
    }

    static final class BuilderImpl extends Iot1ClickProjectsResponse.BuilderImpl implements Builder {
        private ProjectDescription project;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProjectResponse model) {
            super(model);
            project(model.project);
        }

        public final ProjectDescription.Builder getProject() {
            return project != null ? project.toBuilder() : null;
        }

        @Override
        public final Builder project(ProjectDescription project) {
            this.project = project;
            return this;
        }

        public final void setProject(ProjectDescription.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        public DescribeProjectResponse build() {
            return new DescribeProjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
