/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot1clickprojects.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot1clickprojects.model.Iot1ClickProjectsRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.PlacementAttributeMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePlacementRequest
extends Iot1ClickProjectsRequest
implements ToCopyableBuilder<Builder, UpdatePlacementRequest> {
    private static final SdkField<String> PLACEMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("placementName").getter(UpdatePlacementRequest.getter(UpdatePlacementRequest::placementName)).setter(UpdatePlacementRequest.setter(Builder::placementName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("placementName").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectName").getter(UpdatePlacementRequest.getter(UpdatePlacementRequest::projectName)).setter(UpdatePlacementRequest.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(UpdatePlacementRequest.getter(UpdatePlacementRequest::attributes)).setter(UpdatePlacementRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACEMENT_NAME_FIELD, PROJECT_NAME_FIELD, ATTRIBUTES_FIELD));
    private final String placementName;
    private final String projectName;
    private final Map<String, String> attributes;

    private UpdatePlacementRequest(BuilderImpl builder) {
        super(builder);
        this.placementName = builder.placementName;
        this.projectName = builder.projectName;
        this.attributes = builder.attributes;
    }

    public String placementName() {
        return this.placementName;
    }

    public String projectName() {
        return this.projectName;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.placementName());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePlacementRequest)) {
            return false;
        }
        UpdatePlacementRequest other = (UpdatePlacementRequest)((Object)obj);
        return Objects.equals(this.placementName(), other.placementName()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        return ToString.builder((String)"UpdatePlacementRequest").add("PlacementName", (Object)this.placementName()).add("ProjectName", (Object)this.projectName()).add("Attributes", this.attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "placementName": {
                return Optional.ofNullable(clazz.cast(this.placementName()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePlacementRequest, T> g) {
        return obj -> g.apply((UpdatePlacementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Iot1ClickProjectsRequest.BuilderImpl
    implements Builder {
        private String placementName;
        private String projectName;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePlacementRequest model) {
            super(model);
            this.placementName(model.placementName);
            this.projectName(model.projectName);
            this.attributes(model.attributes);
        }

        public final String getPlacementName() {
            return this.placementName;
        }

        @Override
        public final Builder placementName(String placementName) {
            this.placementName = placementName;
            return this;
        }

        public final void setPlacementName(String placementName) {
            this.placementName = placementName;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = PlacementAttributeMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = PlacementAttributeMapCopier.copy(attributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePlacementRequest build() {
            return new UpdatePlacementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Iot1ClickProjectsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePlacementRequest> {
        public Builder placementName(String var1);

        public Builder projectName(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

