/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickprojects.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a device for a placement template (see <a>PlacementTemplate</a>).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceTemplate implements SdkPojo, Serializable, ToCopyableBuilder<DeviceTemplate.Builder, DeviceTemplate> {
    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceType").getter(getter(DeviceTemplate::deviceType)).setter(setter(Builder::deviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceType").build()).build();

    private static final SdkField<Map<String, String>> CALLBACK_OVERRIDES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("callbackOverrides")
            .getter(getter(DeviceTemplate::callbackOverrides))
            .setter(setter(Builder::callbackOverrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("callbackOverrides").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_TYPE_FIELD,
            CALLBACK_OVERRIDES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deviceType;

    private final Map<String, String> callbackOverrides;

    private DeviceTemplate(BuilderImpl builder) {
        this.deviceType = builder.deviceType;
        this.callbackOverrides = builder.callbackOverrides;
    }

    /**
     * <p>
     * The device type, which currently must be <code>"button"</code>.
     * </p>
     * 
     * @return The device type, which currently must be <code>"button"</code>.
     */
    public String deviceType() {
        return deviceType;
    }

    /**
     * Returns true if the CallbackOverrides property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCallbackOverrides() {
        return callbackOverrides != null && !(callbackOverrides instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An optional Lambda function to invoke instead of the default Lambda function provided by the placement template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCallbackOverrides()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An optional Lambda function to invoke instead of the default Lambda function provided by the placement
     *         template.
     */
    public Map<String, String> callbackOverrides() {
        return callbackOverrides;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasCallbackOverrides() ? callbackOverrides() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceTemplate)) {
            return false;
        }
        DeviceTemplate other = (DeviceTemplate) obj;
        return Objects.equals(deviceType(), other.deviceType()) && hasCallbackOverrides() == other.hasCallbackOverrides()
                && Objects.equals(callbackOverrides(), other.callbackOverrides());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeviceTemplate").add("DeviceType", deviceType())
                .add("CallbackOverrides", hasCallbackOverrides() ? callbackOverrides() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deviceType":
            return Optional.ofNullable(clazz.cast(deviceType()));
        case "callbackOverrides":
            return Optional.ofNullable(clazz.cast(callbackOverrides()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceTemplate, T> g) {
        return obj -> g.apply((DeviceTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceTemplate> {
        /**
         * <p>
         * The device type, which currently must be <code>"button"</code>.
         * </p>
         * 
         * @param deviceType
         *        The device type, which currently must be <code>"button"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceType(String deviceType);

        /**
         * <p>
         * An optional Lambda function to invoke instead of the default Lambda function provided by the placement
         * template.
         * </p>
         * 
         * @param callbackOverrides
         *        An optional Lambda function to invoke instead of the default Lambda function provided by the placement
         *        template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callbackOverrides(Map<String, String> callbackOverrides);
    }

    static final class BuilderImpl implements Builder {
        private String deviceType;

        private Map<String, String> callbackOverrides = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceTemplate model) {
            deviceType(model.deviceType);
            callbackOverrides(model.callbackOverrides);
        }

        public final String getDeviceType() {
            return deviceType;
        }

        @Override
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        public final Map<String, String> getCallbackOverrides() {
            if (callbackOverrides instanceof SdkAutoConstructMap) {
                return null;
            }
            return callbackOverrides;
        }

        @Override
        public final Builder callbackOverrides(Map<String, String> callbackOverrides) {
            this.callbackOverrides = DeviceCallbackOverrideMapCopier.copy(callbackOverrides);
            return this;
        }

        public final void setCallbackOverrides(Map<String, String> callbackOverrides) {
            this.callbackOverrides = DeviceCallbackOverrideMapCopier.copy(callbackOverrides);
        }

        @Override
        public DeviceTemplate build() {
            return new DeviceTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
