/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickprojects.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProjectRequest extends Iot1ClickProjectsRequest implements
        ToCopyableBuilder<CreateProjectRequest.Builder, CreateProjectRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectName").getter(getter(CreateProjectRequest::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateProjectRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<PlacementTemplate> PLACEMENT_TEMPLATE_FIELD = SdkField
            .<PlacementTemplate> builder(MarshallingType.SDK_POJO).memberName("placementTemplate")
            .getter(getter(CreateProjectRequest::placementTemplate)).setter(setter(Builder::placementTemplate))
            .constructor(PlacementTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementTemplate").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateProjectRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            DESCRIPTION_FIELD, PLACEMENT_TEMPLATE_FIELD, TAGS_FIELD));

    private final String projectName;

    private final String description;

    private final PlacementTemplate placementTemplate;

    private final Map<String, String> tags;

    private CreateProjectRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.description = builder.description;
        this.placementTemplate = builder.placementTemplate;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the project to create.
     * </p>
     * 
     * @return The name of the project to create.
     */
    public String projectName() {
        return projectName;
    }

    /**
     * <p>
     * An optional description for the project.
     * </p>
     * 
     * @return An optional description for the project.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The schema defining the placement to be created. A placement template defines placement default attributes and
     * device templates. You cannot add or remove device templates after the project has been created. However, you can
     * update <code>callbackOverrides</code> for the device templates using the <code>UpdateProject</code> API.
     * </p>
     * 
     * @return The schema defining the placement to be created. A placement template defines placement default
     *         attributes and device templates. You cannot add or remove device templates after the project has been
     *         created. However, you can update <code>callbackOverrides</code> for the device templates using the
     *         <code>UpdateProject</code> API.
     */
    public PlacementTemplate placementTemplate() {
        return placementTemplate;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Optional tags (metadata key/value pairs) to be associated with the project. For example,
     * <code>{ {"key1": "value1", "key2": "value2"} }</code>. For more information, see <a
     * href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging Strategies</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Optional tags (metadata key/value pairs) to be associated with the project. For example,
     *         <code>{ {"key1": "value1", "key2": "value2"} }</code>. For more information, see <a
     *         href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging
     *         Strategies</a>.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(placementTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectRequest)) {
            return false;
        }
        CreateProjectRequest other = (CreateProjectRequest) obj;
        return Objects.equals(projectName(), other.projectName()) && Objects.equals(description(), other.description())
                && Objects.equals(placementTemplate(), other.placementTemplate()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateProjectRequest").add("ProjectName", projectName()).add("Description", description())
                .add("PlacementTemplate", placementTemplate()).add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "placementTemplate":
            return Optional.ofNullable(clazz.cast(placementTemplate()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProjectRequest, T> g) {
        return obj -> g.apply((CreateProjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Iot1ClickProjectsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateProjectRequest> {
        /**
         * <p>
         * The name of the project to create.
         * </p>
         * 
         * @param projectName
         *        The name of the project to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * An optional description for the project.
         * </p>
         * 
         * @param description
         *        An optional description for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The schema defining the placement to be created. A placement template defines placement default attributes
         * and device templates. You cannot add or remove device templates after the project has been created. However,
         * you can update <code>callbackOverrides</code> for the device templates using the <code>UpdateProject</code>
         * API.
         * </p>
         * 
         * @param placementTemplate
         *        The schema defining the placement to be created. A placement template defines placement default
         *        attributes and device templates. You cannot add or remove device templates after the project has been
         *        created. However, you can update <code>callbackOverrides</code> for the device templates using the
         *        <code>UpdateProject</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementTemplate(PlacementTemplate placementTemplate);

        /**
         * <p>
         * The schema defining the placement to be created. A placement template defines placement default attributes
         * and device templates. You cannot add or remove device templates after the project has been created. However,
         * you can update <code>callbackOverrides</code> for the device templates using the <code>UpdateProject</code>
         * API.
         * </p>
         * This is a convenience that creates an instance of the {@link PlacementTemplate.Builder} avoiding the need to
         * create one manually via {@link PlacementTemplate#builder()}.
         *
         * When the {@link Consumer} completes, {@link PlacementTemplate.Builder#build()} is called immediately and its
         * result is passed to {@link #placementTemplate(PlacementTemplate)}.
         * 
         * @param placementTemplate
         *        a consumer that will call methods on {@link PlacementTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementTemplate(PlacementTemplate)
         */
        default Builder placementTemplate(Consumer<PlacementTemplate.Builder> placementTemplate) {
            return placementTemplate(PlacementTemplate.builder().applyMutation(placementTemplate).build());
        }

        /**
         * <p>
         * Optional tags (metadata key/value pairs) to be associated with the project. For example,
         * <code>{ {"key1": "value1", "key2": "value2"} }</code>. For more information, see <a
         * href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging Strategies</a>.
         * </p>
         * 
         * @param tags
         *        Optional tags (metadata key/value pairs) to be associated with the project. For example,
         *        <code>{ {"key1": "value1", "key2": "value2"} }</code>. For more information, see <a
         *        href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging
         *        Strategies</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Iot1ClickProjectsRequest.BuilderImpl implements Builder {
        private String projectName;

        private String description;

        private PlacementTemplate placementTemplate;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectRequest model) {
            super(model);
            projectName(model.projectName);
            description(model.description);
            placementTemplate(model.placementTemplate);
            tags(model.tags);
        }

        public final String getProjectName() {
            return projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final PlacementTemplate.Builder getPlacementTemplate() {
            return placementTemplate != null ? placementTemplate.toBuilder() : null;
        }

        @Override
        public final Builder placementTemplate(PlacementTemplate placementTemplate) {
            this.placementTemplate = placementTemplate;
            return this;
        }

        public final void setPlacementTemplate(PlacementTemplate.BuilderImpl placementTemplate) {
            this.placementTemplate = placementTemplate != null ? placementTemplate.build() : null;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProjectRequest build() {
            return new CreateProjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
