/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickprojects.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object providing detailed information for a particular project associated with an AWS account and region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProjectDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<ProjectDescription.Builder, ProjectDescription> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ProjectDescription::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectName").getter(getter(ProjectDescription::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ProjectDescription::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate").getter(getter(ProjectDescription::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<Instant> UPDATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedDate").getter(getter(ProjectDescription::updatedDate)).setter(setter(Builder::updatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedDate").build()).build();

    private static final SdkField<PlacementTemplate> PLACEMENT_TEMPLATE_FIELD = SdkField
            .<PlacementTemplate> builder(MarshallingType.SDK_POJO).memberName("placementTemplate")
            .getter(getter(ProjectDescription::placementTemplate)).setter(setter(Builder::placementTemplate))
            .constructor(PlacementTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementTemplate").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(ProjectDescription::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, PROJECT_NAME_FIELD,
            DESCRIPTION_FIELD, CREATED_DATE_FIELD, UPDATED_DATE_FIELD, PLACEMENT_TEMPLATE_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String projectName;

    private final String description;

    private final Instant createdDate;

    private final Instant updatedDate;

    private final PlacementTemplate placementTemplate;

    private final Map<String, String> tags;

    private ProjectDescription(BuilderImpl builder) {
        this.arn = builder.arn;
        this.projectName = builder.projectName;
        this.description = builder.description;
        this.createdDate = builder.createdDate;
        this.updatedDate = builder.updatedDate;
        this.placementTemplate = builder.placementTemplate;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ARN of the project.
     * </p>
     * 
     * @return The ARN of the project.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the project for which to obtain information from.
     * </p>
     * 
     * @return The name of the project for which to obtain information from.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The description of the project.
     * </p>
     * 
     * @return The description of the project.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date when the project was originally created, in UNIX epoch time format.
     * </p>
     * 
     * @return The date when the project was originally created, in UNIX epoch time format.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The date when the project was last updated, in UNIX epoch time format. If the project was not updated, then
     * <code>createdDate</code> and <code>updatedDate</code> are the same.
     * </p>
     * 
     * @return The date when the project was last updated, in UNIX epoch time format. If the project was not updated,
     *         then <code>createdDate</code> and <code>updatedDate</code> are the same.
     */
    public final Instant updatedDate() {
        return updatedDate;
    }

    /**
     * <p>
     * An object describing the project's placement specifications.
     * </p>
     * 
     * @return An object describing the project's placement specifications.
     */
    public final PlacementTemplate placementTemplate() {
        return placementTemplate;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags (metadata key/value pairs) associated with the project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags (metadata key/value pairs) associated with the project.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(updatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(placementTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectDescription)) {
            return false;
        }
        ProjectDescription other = (ProjectDescription) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(projectName(), other.projectName())
                && Objects.equals(description(), other.description()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(updatedDate(), other.updatedDate())
                && Objects.equals(placementTemplate(), other.placementTemplate()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProjectDescription").add("Arn", arn()).add("ProjectName", projectName())
                .add("Description", description()).add("CreatedDate", createdDate()).add("UpdatedDate", updatedDate())
                .add("PlacementTemplate", placementTemplate()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "projectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "updatedDate":
            return Optional.ofNullable(clazz.cast(updatedDate()));
        case "placementTemplate":
            return Optional.ofNullable(clazz.cast(placementTemplate()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProjectDescription, T> g) {
        return obj -> g.apply((ProjectDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProjectDescription> {
        /**
         * <p>
         * The ARN of the project.
         * </p>
         * 
         * @param arn
         *        The ARN of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the project for which to obtain information from.
         * </p>
         * 
         * @param projectName
         *        The name of the project for which to obtain information from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The description of the project.
         * </p>
         * 
         * @param description
         *        The description of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date when the project was originally created, in UNIX epoch time format.
         * </p>
         * 
         * @param createdDate
         *        The date when the project was originally created, in UNIX epoch time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The date when the project was last updated, in UNIX epoch time format. If the project was not updated, then
         * <code>createdDate</code> and <code>updatedDate</code> are the same.
         * </p>
         * 
         * @param updatedDate
         *        The date when the project was last updated, in UNIX epoch time format. If the project was not updated,
         *        then <code>createdDate</code> and <code>updatedDate</code> are the same.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedDate(Instant updatedDate);

        /**
         * <p>
         * An object describing the project's placement specifications.
         * </p>
         * 
         * @param placementTemplate
         *        An object describing the project's placement specifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementTemplate(PlacementTemplate placementTemplate);

        /**
         * <p>
         * An object describing the project's placement specifications.
         * </p>
         * This is a convenience that creates an instance of the {@link PlacementTemplate.Builder} avoiding the need to
         * create one manually via {@link PlacementTemplate#builder()}.
         *
         * When the {@link Consumer} completes, {@link PlacementTemplate.Builder#build()} is called immediately and its
         * result is passed to {@link #placementTemplate(PlacementTemplate)}.
         * 
         * @param placementTemplate
         *        a consumer that will call methods on {@link PlacementTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementTemplate(PlacementTemplate)
         */
        default Builder placementTemplate(Consumer<PlacementTemplate.Builder> placementTemplate) {
            return placementTemplate(PlacementTemplate.builder().applyMutation(placementTemplate).build());
        }

        /**
         * <p>
         * The tags (metadata key/value pairs) associated with the project.
         * </p>
         * 
         * @param tags
         *        The tags (metadata key/value pairs) associated with the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String projectName;

        private String description;

        private Instant createdDate;

        private Instant updatedDate;

        private PlacementTemplate placementTemplate;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectDescription model) {
            arn(model.arn);
            projectName(model.projectName);
            description(model.description);
            createdDate(model.createdDate);
            updatedDate(model.updatedDate);
            placementTemplate(model.placementTemplate);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        @Transient
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        @Transient
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getUpdatedDate() {
            return updatedDate;
        }

        public final void setUpdatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
        }

        @Override
        @Transient
        public final Builder updatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public final PlacementTemplate.Builder getPlacementTemplate() {
            return placementTemplate != null ? placementTemplate.toBuilder() : null;
        }

        public final void setPlacementTemplate(PlacementTemplate.BuilderImpl placementTemplate) {
            this.placementTemplate = placementTemplate != null ? placementTemplate.build() : null;
        }

        @Override
        @Transient
        public final Builder placementTemplate(PlacementTemplate placementTemplate) {
            this.placementTemplate = placementTemplate;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public ProjectDescription build() {
            return new ProjectDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
