/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickprojects.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProjectRequest extends Iot1ClickProjectsRequest implements
        ToCopyableBuilder<UpdateProjectRequest.Builder, UpdateProjectRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectName").getter(getter(UpdateProjectRequest::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateProjectRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<PlacementTemplate> PLACEMENT_TEMPLATE_FIELD = SdkField
            .<PlacementTemplate> builder(MarshallingType.SDK_POJO).memberName("placementTemplate")
            .getter(getter(UpdateProjectRequest::placementTemplate)).setter(setter(Builder::placementTemplate))
            .constructor(PlacementTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            DESCRIPTION_FIELD, PLACEMENT_TEMPLATE_FIELD));

    private final String projectName;

    private final String description;

    private final PlacementTemplate placementTemplate;

    private UpdateProjectRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.description = builder.description;
        this.placementTemplate = builder.placementTemplate;
    }

    /**
     * <p>
     * The name of the project to be updated.
     * </p>
     * 
     * @return The name of the project to be updated.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * An optional user-defined description for the project.
     * </p>
     * 
     * @return An optional user-defined description for the project.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * An object defining the project update. Once a project has been created, you cannot add device template names to
     * the project. However, for a given <code>placementTemplate</code>, you can update the associated
     * <code>callbackOverrides</code> for the device definition using this API.
     * </p>
     * 
     * @return An object defining the project update. Once a project has been created, you cannot add device template
     *         names to the project. However, for a given <code>placementTemplate</code>, you can update the associated
     *         <code>callbackOverrides</code> for the device definition using this API.
     */
    public final PlacementTemplate placementTemplate() {
        return placementTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(placementTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProjectRequest)) {
            return false;
        }
        UpdateProjectRequest other = (UpdateProjectRequest) obj;
        return Objects.equals(projectName(), other.projectName()) && Objects.equals(description(), other.description())
                && Objects.equals(placementTemplate(), other.placementTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProjectRequest").add("ProjectName", projectName()).add("Description", description())
                .add("PlacementTemplate", placementTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "placementTemplate":
            return Optional.ofNullable(clazz.cast(placementTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProjectRequest, T> g) {
        return obj -> g.apply((UpdateProjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Iot1ClickProjectsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProjectRequest> {
        /**
         * <p>
         * The name of the project to be updated.
         * </p>
         * 
         * @param projectName
         *        The name of the project to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * An optional user-defined description for the project.
         * </p>
         * 
         * @param description
         *        An optional user-defined description for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An object defining the project update. Once a project has been created, you cannot add device template names
         * to the project. However, for a given <code>placementTemplate</code>, you can update the associated
         * <code>callbackOverrides</code> for the device definition using this API.
         * </p>
         * 
         * @param placementTemplate
         *        An object defining the project update. Once a project has been created, you cannot add device template
         *        names to the project. However, for a given <code>placementTemplate</code>, you can update the
         *        associated <code>callbackOverrides</code> for the device definition using this API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementTemplate(PlacementTemplate placementTemplate);

        /**
         * <p>
         * An object defining the project update. Once a project has been created, you cannot add device template names
         * to the project. However, for a given <code>placementTemplate</code>, you can update the associated
         * <code>callbackOverrides</code> for the device definition using this API.
         * </p>
         * This is a convenience that creates an instance of the {@link PlacementTemplate.Builder} avoiding the need to
         * create one manually via {@link PlacementTemplate#builder()}.
         *
         * When the {@link Consumer} completes, {@link PlacementTemplate.Builder#build()} is called immediately and its
         * result is passed to {@link #placementTemplate(PlacementTemplate)}.
         * 
         * @param placementTemplate
         *        a consumer that will call methods on {@link PlacementTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementTemplate(PlacementTemplate)
         */
        default Builder placementTemplate(Consumer<PlacementTemplate.Builder> placementTemplate) {
            return placementTemplate(PlacementTemplate.builder().applyMutation(placementTemplate).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Iot1ClickProjectsRequest.BuilderImpl implements Builder {
        private String projectName;

        private String description;

        private PlacementTemplate placementTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProjectRequest model) {
            super(model);
            projectName(model.projectName);
            description(model.description);
            placementTemplate(model.placementTemplate);
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        @Transient
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final PlacementTemplate.Builder getPlacementTemplate() {
            return placementTemplate != null ? placementTemplate.toBuilder() : null;
        }

        public final void setPlacementTemplate(PlacementTemplate.BuilderImpl placementTemplate) {
            this.placementTemplate = placementTemplate != null ? placementTemplate.build() : null;
        }

        @Override
        @Transient
        public final Builder placementTemplate(PlacementTemplate placementTemplate) {
            this.placementTemplate = placementTemplate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProjectRequest build() {
            return new UpdateProjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
