/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickprojects.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateDeviceFromPlacementRequest extends Iot1ClickProjectsRequest implements
        ToCopyableBuilder<DisassociateDeviceFromPlacementRequest.Builder, DisassociateDeviceFromPlacementRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectName").getter(getter(DisassociateDeviceFromPlacementRequest::projectName))
            .setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()).build();

    private static final SdkField<String> PLACEMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("placementName").getter(getter(DisassociateDeviceFromPlacementRequest::placementName))
            .setter(setter(Builder::placementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("placementName").build()).build();

    private static final SdkField<String> DEVICE_TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceTemplateName").getter(getter(DisassociateDeviceFromPlacementRequest::deviceTemplateName))
            .setter(setter(Builder::deviceTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("deviceTemplateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            PLACEMENT_NAME_FIELD, DEVICE_TEMPLATE_NAME_FIELD));

    private final String projectName;

    private final String placementName;

    private final String deviceTemplateName;

    private DisassociateDeviceFromPlacementRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.placementName = builder.placementName;
        this.deviceTemplateName = builder.deviceTemplateName;
    }

    /**
     * <p>
     * The name of the project that contains the placement.
     * </p>
     * 
     * @return The name of the project that contains the placement.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The name of the placement that the device should be removed from.
     * </p>
     * 
     * @return The name of the placement that the device should be removed from.
     */
    public final String placementName() {
        return placementName;
    }

    /**
     * <p>
     * The device ID that should be removed from the placement.
     * </p>
     * 
     * @return The device ID that should be removed from the placement.
     */
    public final String deviceTemplateName() {
        return deviceTemplateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(placementName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTemplateName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateDeviceFromPlacementRequest)) {
            return false;
        }
        DisassociateDeviceFromPlacementRequest other = (DisassociateDeviceFromPlacementRequest) obj;
        return Objects.equals(projectName(), other.projectName()) && Objects.equals(placementName(), other.placementName())
                && Objects.equals(deviceTemplateName(), other.deviceTemplateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateDeviceFromPlacementRequest").add("ProjectName", projectName())
                .add("PlacementName", placementName()).add("DeviceTemplateName", deviceTemplateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "placementName":
            return Optional.ofNullable(clazz.cast(placementName()));
        case "deviceTemplateName":
            return Optional.ofNullable(clazz.cast(deviceTemplateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateDeviceFromPlacementRequest, T> g) {
        return obj -> g.apply((DisassociateDeviceFromPlacementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Iot1ClickProjectsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateDeviceFromPlacementRequest> {
        /**
         * <p>
         * The name of the project that contains the placement.
         * </p>
         * 
         * @param projectName
         *        The name of the project that contains the placement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The name of the placement that the device should be removed from.
         * </p>
         * 
         * @param placementName
         *        The name of the placement that the device should be removed from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementName(String placementName);

        /**
         * <p>
         * The device ID that should be removed from the placement.
         * </p>
         * 
         * @param deviceTemplateName
         *        The device ID that should be removed from the placement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTemplateName(String deviceTemplateName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Iot1ClickProjectsRequest.BuilderImpl implements Builder {
        private String projectName;

        private String placementName;

        private String deviceTemplateName;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateDeviceFromPlacementRequest model) {
            super(model);
            projectName(model.projectName);
            placementName(model.placementName);
            deviceTemplateName(model.deviceTemplateName);
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        @Transient
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getPlacementName() {
            return placementName;
        }

        public final void setPlacementName(String placementName) {
            this.placementName = placementName;
        }

        @Override
        @Transient
        public final Builder placementName(String placementName) {
            this.placementName = placementName;
            return this;
        }

        public final String getDeviceTemplateName() {
            return deviceTemplateName;
        }

        public final void setDeviceTemplateName(String deviceTemplateName) {
            this.deviceTemplateName = deviceTemplateName;
        }

        @Override
        @Transient
        public final Builder deviceTemplateName(String deviceTemplateName) {
            this.deviceTemplateName = deviceTemplateName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateDeviceFromPlacementRequest build() {
            return new DisassociateDeviceFromPlacementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
