/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot1clickprojects.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot1clickprojects.Iot1ClickProjectsAsyncClient;
import software.amazon.awssdk.services.iot1clickprojects.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.ProjectSummary;

public class ListProjectsPublisher
implements SdkPublisher<ListProjectsResponse> {
    private final Iot1ClickProjectsAsyncClient client;
    private final ListProjectsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProjectsPublisher(Iot1ClickProjectsAsyncClient client, ListProjectsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProjectsPublisher(Iot1ClickProjectsAsyncClient client, ListProjectsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProjectsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProjectsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProjectSummary> projects() {
        Function<ListProjectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.projects() != null) {
                return response.projects().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProjectsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProjectsResponseFetcher
    implements AsyncPageFetcher<ListProjectsResponse> {
        private ListProjectsResponseFetcher() {
        }

        public boolean hasNextPage(ListProjectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProjectsResponse> nextPage(ListProjectsResponse previousPage) {
            if (previousPage == null) {
                return ListProjectsPublisher.this.client.listProjects(ListProjectsPublisher.this.firstRequest);
            }
            return ListProjectsPublisher.this.client.listProjects((ListProjectsRequest)((Object)ListProjectsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

