/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot1clickprojects.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectSummary> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectSummary.getter(ProjectSummary::projectName)).setter(ProjectSummary.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ProjectSummary.getter(ProjectSummary::createdDate)).setter(ProjectSummary.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()}).build();
    private static final SdkField<Instant> UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ProjectSummary.getter(ProjectSummary::updatedDate)).setter(ProjectSummary.setter(Builder::updatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD, CREATED_DATE_FIELD, UPDATED_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String projectName;
    private final Instant createdDate;
    private final Instant updatedDate;

    private ProjectSummary(BuilderImpl builder) {
        this.projectName = builder.projectName;
        this.createdDate = builder.createdDate;
        this.updatedDate = builder.updatedDate;
    }

    public String projectName() {
        return this.projectName;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public Instant updatedDate() {
        return this.updatedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectSummary)) {
            return false;
        }
        ProjectSummary other = (ProjectSummary)obj;
        return Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.updatedDate(), other.updatedDate());
    }

    public String toString() {
        return ToString.builder((String)"ProjectSummary").add("ProjectName", (Object)this.projectName()).add("CreatedDate", (Object)this.createdDate()).add("UpdatedDate", (Object)this.updatedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "updatedDate": {
                return Optional.ofNullable(clazz.cast(this.updatedDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProjectSummary, T> g) {
        return obj -> g.apply((ProjectSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String projectName;
        private Instant createdDate;
        private Instant updatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectSummary model) {
            this.projectName(model.projectName);
            this.createdDate(model.createdDate);
            this.updatedDate(model.updatedDate);
        }

        public final String getProjectName() {
            return this.projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getUpdatedDate() {
            return this.updatedDate;
        }

        @Override
        public final Builder updatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public final void setUpdatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
        }

        public ProjectSummary build() {
            return new ProjectSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectSummary> {
        public Builder projectName(String var1);

        public Builder createdDate(Instant var1);

        public Builder updatedDate(Instant var1);
    }
}

