/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickprojects.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePlacementRequest extends Iot1ClickProjectsRequest implements
        ToCopyableBuilder<DeletePlacementRequest.Builder, DeletePlacementRequest> {
    private static final SdkField<String> PLACEMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeletePlacementRequest::placementName)).setter(setter(Builder::placementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("placementName").build()).build();

    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeletePlacementRequest::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("projectName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACEMENT_NAME_FIELD,
            PROJECT_NAME_FIELD));

    private final String placementName;

    private final String projectName;

    private DeletePlacementRequest(BuilderImpl builder) {
        super(builder);
        this.placementName = builder.placementName;
        this.projectName = builder.projectName;
    }

    /**
     * <p>
     * The name of the empty placement to delete.
     * </p>
     * 
     * @return The name of the empty placement to delete.
     */
    public String placementName() {
        return placementName;
    }

    /**
     * <p>
     * The project containing the empty placement to delete.
     * </p>
     * 
     * @return The project containing the empty placement to delete.
     */
    public String projectName() {
        return projectName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(placementName());
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePlacementRequest)) {
            return false;
        }
        DeletePlacementRequest other = (DeletePlacementRequest) obj;
        return Objects.equals(placementName(), other.placementName()) && Objects.equals(projectName(), other.projectName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeletePlacementRequest").add("PlacementName", placementName()).add("ProjectName", projectName())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "placementName":
            return Optional.ofNullable(clazz.cast(placementName()));
        case "projectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePlacementRequest, T> g) {
        return obj -> g.apply((DeletePlacementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Iot1ClickProjectsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeletePlacementRequest> {
        /**
         * <p>
         * The name of the empty placement to delete.
         * </p>
         * 
         * @param placementName
         *        The name of the empty placement to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementName(String placementName);

        /**
         * <p>
         * The project containing the empty placement to delete.
         * </p>
         * 
         * @param projectName
         *        The project containing the empty placement to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Iot1ClickProjectsRequest.BuilderImpl implements Builder {
        private String placementName;

        private String projectName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePlacementRequest model) {
            super(model);
            placementName(model.placementName);
            projectName(model.projectName);
        }

        public final String getPlacementName() {
            return placementName;
        }

        @Override
        public final Builder placementName(String placementName) {
            this.placementName = placementName;
            return this;
        }

        public final void setPlacementName(String placementName) {
            this.placementName = placementName;
        }

        public final String getProjectName() {
            return projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeletePlacementRequest build() {
            return new DeletePlacementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
