/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickprojects.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDevicesInPlacementResponse extends Iot1ClickProjectsResponse implements
        ToCopyableBuilder<GetDevicesInPlacementResponse.Builder, GetDevicesInPlacementResponse> {
    private static final SdkField<Map<String, String>> DEVICES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(GetDevicesInPlacementResponse::devices))
            .setter(setter(Builder::devices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devices").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICES_FIELD));

    private final Map<String, String> devices;

    private GetDevicesInPlacementResponse(BuilderImpl builder) {
        super(builder);
        this.devices = builder.devices;
    }

    /**
     * <p>
     * An object containing the devices (zero or more) within the placement.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An object containing the devices (zero or more) within the placement.
     */
    public Map<String, String> devices() {
        return devices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(devices());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDevicesInPlacementResponse)) {
            return false;
        }
        GetDevicesInPlacementResponse other = (GetDevicesInPlacementResponse) obj;
        return Objects.equals(devices(), other.devices());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDevicesInPlacementResponse").add("Devices", devices()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "devices":
            return Optional.ofNullable(clazz.cast(devices()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDevicesInPlacementResponse, T> g) {
        return obj -> g.apply((GetDevicesInPlacementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Iot1ClickProjectsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDevicesInPlacementResponse> {
        /**
         * <p>
         * An object containing the devices (zero or more) within the placement.
         * </p>
         * 
         * @param devices
         *        An object containing the devices (zero or more) within the placement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(Map<String, String> devices);
    }

    static final class BuilderImpl extends Iot1ClickProjectsResponse.BuilderImpl implements Builder {
        private Map<String, String> devices = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDevicesInPlacementResponse model) {
            super(model);
            devices(model.devices);
        }

        public final Map<String, String> getDevices() {
            return devices;
        }

        @Override
        public final Builder devices(Map<String, String> devices) {
            this.devices = DeviceMapCopier.copy(devices);
            return this;
        }

        public final void setDevices(Map<String, String> devices) {
            this.devices = DeviceMapCopier.copy(devices);
        }

        @Override
        public GetDevicesInPlacementResponse build() {
            return new GetDevicesInPlacementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
