/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot1clickprojects.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot1clickprojects.model.Iot1ClickProjectsResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.ProjectSummary;
import software.amazon.awssdk.services.iot1clickprojects.model.ProjectSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProjectsResponse
extends Iot1ClickProjectsResponse
implements ToCopyableBuilder<Builder, ListProjectsResponse> {
    private static final SdkField<List<ProjectSummary>> PROJECTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListProjectsResponse.getter(ListProjectsResponse::projects)).setter(ListProjectsResponse.setter(Builder::projects)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projects").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListProjectsResponse.getter(ListProjectsResponse::nextToken)).setter(ListProjectsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ProjectSummary> projects;
    private final String nextToken;

    private ListProjectsResponse(BuilderImpl builder) {
        super(builder);
        this.projects = builder.projects;
        this.nextToken = builder.nextToken;
    }

    public List<ProjectSummary> projects() {
        return this.projects;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projects());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProjectsResponse)) {
            return false;
        }
        ListProjectsResponse other = (ListProjectsResponse)((Object)obj);
        return Objects.equals(this.projects(), other.projects()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListProjectsResponse").add("Projects", this.projects()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "projects": {
                return Optional.ofNullable(clazz.cast(this.projects()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProjectsResponse, T> g) {
        return obj -> g.apply((ListProjectsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Iot1ClickProjectsResponse.BuilderImpl
    implements Builder {
        private List<ProjectSummary> projects = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProjectsResponse model) {
            super(model);
            this.projects(model.projects);
            this.nextToken(model.nextToken);
        }

        public final Collection<ProjectSummary.Builder> getProjects() {
            return this.projects != null ? (Collection)this.projects.stream().map(ProjectSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder projects(Collection<ProjectSummary> projects) {
            this.projects = ProjectSummaryListCopier.copy(projects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projects(ProjectSummary ... projects) {
            this.projects(Arrays.asList(projects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projects(Consumer<ProjectSummary.Builder> ... projects) {
            this.projects(Stream.of(projects).map(c -> (ProjectSummary)((ProjectSummary.Builder)ProjectSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProjects(Collection<ProjectSummary.BuilderImpl> projects) {
            this.projects = ProjectSummaryListCopier.copyFromBuilder(projects);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListProjectsResponse build() {
            return new ListProjectsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Iot1ClickProjectsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProjectsResponse> {
        public Builder projects(Collection<ProjectSummary> var1);

        public Builder projects(ProjectSummary ... var1);

        public Builder projects(Consumer<ProjectSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

