/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot1clickprojects.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iot1clickprojects.model.PlacementTemplate;
import software.amazon.awssdk.services.iot1clickprojects.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProjectDescription> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectDescription.getter(ProjectDescription::arn)).setter(ProjectDescription.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectDescription.getter(ProjectDescription::projectName)).setter(ProjectDescription.setter(Builder::projectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProjectDescription.getter(ProjectDescription::description)).setter(ProjectDescription.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ProjectDescription.getter(ProjectDescription::createdDate)).setter(ProjectDescription.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()}).build();
    private static final SdkField<Instant> UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ProjectDescription.getter(ProjectDescription::updatedDate)).setter(ProjectDescription.setter(Builder::updatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedDate").build()}).build();
    private static final SdkField<PlacementTemplate> PLACEMENT_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ProjectDescription.getter(ProjectDescription::placementTemplate)).setter(ProjectDescription.setter(Builder::placementTemplate)).constructor(PlacementTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementTemplate").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ProjectDescription.getter(ProjectDescription::tags)).setter(ProjectDescription.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, PROJECT_NAME_FIELD, DESCRIPTION_FIELD, CREATED_DATE_FIELD, UPDATED_DATE_FIELD, PLACEMENT_TEMPLATE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String projectName;
    private final String description;
    private final Instant createdDate;
    private final Instant updatedDate;
    private final PlacementTemplate placementTemplate;
    private final Map<String, String> tags;

    private ProjectDescription(BuilderImpl builder) {
        this.arn = builder.arn;
        this.projectName = builder.projectName;
        this.description = builder.description;
        this.createdDate = builder.createdDate;
        this.updatedDate = builder.updatedDate;
        this.placementTemplate = builder.placementTemplate;
        this.tags = builder.tags;
    }

    public String arn() {
        return this.arn;
    }

    public String projectName() {
        return this.projectName;
    }

    public String description() {
        return this.description;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public Instant updatedDate() {
        return this.updatedDate;
    }

    public PlacementTemplate placementTemplate() {
        return this.placementTemplate;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectDescription)) {
            return false;
        }
        ProjectDescription other = (ProjectDescription)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.updatedDate(), other.updatedDate()) && Objects.equals(this.placementTemplate(), other.placementTemplate()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"ProjectDescription").add("Arn", (Object)this.arn()).add("ProjectName", (Object)this.projectName()).add("Description", (Object)this.description()).add("CreatedDate", (Object)this.createdDate()).add("UpdatedDate", (Object)this.updatedDate()).add("PlacementTemplate", (Object)this.placementTemplate()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "updatedDate": {
                return Optional.ofNullable(clazz.cast(this.updatedDate()));
            }
            case "placementTemplate": {
                return Optional.ofNullable(clazz.cast(this.placementTemplate()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProjectDescription, T> g) {
        return obj -> g.apply((ProjectDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String projectName;
        private String description;
        private Instant createdDate;
        private Instant updatedDate;
        private PlacementTemplate placementTemplate;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectDescription model) {
            this.arn(model.arn);
            this.projectName(model.projectName);
            this.description(model.description);
            this.createdDate(model.createdDate);
            this.updatedDate(model.updatedDate);
            this.placementTemplate(model.placementTemplate);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getUpdatedDate() {
            return this.updatedDate;
        }

        @Override
        public final Builder updatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public final void setUpdatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
        }

        public final PlacementTemplate.Builder getPlacementTemplate() {
            return this.placementTemplate != null ? this.placementTemplate.toBuilder() : null;
        }

        @Override
        public final Builder placementTemplate(PlacementTemplate placementTemplate) {
            this.placementTemplate = placementTemplate;
            return this;
        }

        public final void setPlacementTemplate(PlacementTemplate.BuilderImpl placementTemplate) {
            this.placementTemplate = placementTemplate != null ? placementTemplate.build() : null;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public ProjectDescription build() {
            return new ProjectDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProjectDescription> {
        public Builder arn(String var1);

        public Builder projectName(String var1);

        public Builder description(String var1);

        public Builder createdDate(Instant var1);

        public Builder updatedDate(Instant var1);

        public Builder placementTemplate(PlacementTemplate var1);

        default public Builder placementTemplate(Consumer<PlacementTemplate.Builder> placementTemplate) {
            return this.placementTemplate((PlacementTemplate)((PlacementTemplate.Builder)PlacementTemplate.builder().applyMutation(placementTemplate)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

