/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickprojects.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object defining the template for a placement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlacementTemplate implements SdkPojo, Serializable,
        ToCopyableBuilder<PlacementTemplate.Builder, PlacementTemplate> {
    private static final SdkField<Map<String, String>> DEFAULT_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(PlacementTemplate::defaultAttributes))
            .setter(setter(Builder::defaultAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, DeviceTemplate>> DEVICE_TEMPLATES_FIELD = SdkField
            .<Map<String, DeviceTemplate>> builder(MarshallingType.MAP)
            .getter(getter(PlacementTemplate::deviceTemplates))
            .setter(setter(Builder::deviceTemplates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceTemplates").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<DeviceTemplate> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceTemplate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_ATTRIBUTES_FIELD,
            DEVICE_TEMPLATES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> defaultAttributes;

    private final Map<String, DeviceTemplate> deviceTemplates;

    private PlacementTemplate(BuilderImpl builder) {
        this.defaultAttributes = builder.defaultAttributes;
        this.deviceTemplates = builder.deviceTemplates;
    }

    /**
     * <p>
     * The default attributes (key/value pairs) to be applied to all placements using this template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The default attributes (key/value pairs) to be applied to all placements using this template.
     */
    public Map<String, String> defaultAttributes() {
        return defaultAttributes;
    }

    /**
     * <p>
     * An object specifying the <a>DeviceTemplate</a> for all placements using this (<a>PlacementTemplate</a>) template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An object specifying the <a>DeviceTemplate</a> for all placements using this (<a>PlacementTemplate</a>)
     *         template.
     */
    public Map<String, DeviceTemplate> deviceTemplates() {
        return deviceTemplates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTemplates());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacementTemplate)) {
            return false;
        }
        PlacementTemplate other = (PlacementTemplate) obj;
        return Objects.equals(defaultAttributes(), other.defaultAttributes())
                && Objects.equals(deviceTemplates(), other.deviceTemplates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PlacementTemplate").add("DefaultAttributes", defaultAttributes())
                .add("DeviceTemplates", deviceTemplates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "defaultAttributes":
            return Optional.ofNullable(clazz.cast(defaultAttributes()));
        case "deviceTemplates":
            return Optional.ofNullable(clazz.cast(deviceTemplates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlacementTemplate, T> g) {
        return obj -> g.apply((PlacementTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlacementTemplate> {
        /**
         * <p>
         * The default attributes (key/value pairs) to be applied to all placements using this template.
         * </p>
         * 
         * @param defaultAttributes
         *        The default attributes (key/value pairs) to be applied to all placements using this template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAttributes(Map<String, String> defaultAttributes);

        /**
         * <p>
         * An object specifying the <a>DeviceTemplate</a> for all placements using this (<a>PlacementTemplate</a>)
         * template.
         * </p>
         * 
         * @param deviceTemplates
         *        An object specifying the <a>DeviceTemplate</a> for all placements using this
         *        (<a>PlacementTemplate</a>) template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceTemplates(Map<String, DeviceTemplate> deviceTemplates);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> defaultAttributes = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, DeviceTemplate> deviceTemplates = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PlacementTemplate model) {
            defaultAttributes(model.defaultAttributes);
            deviceTemplates(model.deviceTemplates);
        }

        public final Map<String, String> getDefaultAttributes() {
            return defaultAttributes;
        }

        @Override
        public final Builder defaultAttributes(Map<String, String> defaultAttributes) {
            this.defaultAttributes = DefaultPlacementAttributeMapCopier.copy(defaultAttributes);
            return this;
        }

        public final void setDefaultAttributes(Map<String, String> defaultAttributes) {
            this.defaultAttributes = DefaultPlacementAttributeMapCopier.copy(defaultAttributes);
        }

        public final Map<String, DeviceTemplate.Builder> getDeviceTemplates() {
            return deviceTemplates != null ? CollectionUtils.mapValues(deviceTemplates, DeviceTemplate::toBuilder) : null;
        }

        @Override
        public final Builder deviceTemplates(Map<String, DeviceTemplate> deviceTemplates) {
            this.deviceTemplates = DeviceTemplateMapCopier.copy(deviceTemplates);
            return this;
        }

        public final void setDeviceTemplates(Map<String, DeviceTemplate.BuilderImpl> deviceTemplates) {
            this.deviceTemplates = DeviceTemplateMapCopier.copyFromBuilder(deviceTemplates);
        }

        @Override
        public PlacementTemplate build() {
            return new PlacementTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
