/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotanalytics.model.DatasetAction;
import software.amazon.awssdk.services.iotanalytics.model.DatasetActionsCopier;
import software.amazon.awssdk.services.iotanalytics.model.DatasetContentDeliveryRule;
import software.amazon.awssdk.services.iotanalytics.model.DatasetContentDeliveryRulesCopier;
import software.amazon.awssdk.services.iotanalytics.model.DatasetStatus;
import software.amazon.awssdk.services.iotanalytics.model.DatasetTrigger;
import software.amazon.awssdk.services.iotanalytics.model.DatasetTriggersCopier;
import software.amazon.awssdk.services.iotanalytics.model.RetentionPeriod;
import software.amazon.awssdk.services.iotanalytics.model.VersioningConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Dataset
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Dataset> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Dataset.getter(Dataset::name)).setter(Dataset.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Dataset.getter(Dataset::arn)).setter(Dataset.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<DatasetAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Dataset.getter(Dataset::actions)).setter(Dataset.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DatasetTrigger>> TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Dataset.getter(Dataset::triggers)).setter(Dataset.setter(Builder::triggers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetTrigger::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DatasetContentDeliveryRule>> CONTENT_DELIVERY_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Dataset.getter(Dataset::contentDeliveryRules)).setter(Dataset.setter(Builder::contentDeliveryRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentDeliveryRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetContentDeliveryRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Dataset.getter(Dataset::statusAsString)).setter(Dataset.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Dataset.getter(Dataset::creationTime)).setter(Dataset.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Dataset.getter(Dataset::lastUpdateTime)).setter(Dataset.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Dataset.getter(Dataset::retentionPeriod)).setter(Dataset.setter(Builder::retentionPeriod)).constructor(RetentionPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()}).build();
    private static final SdkField<VersioningConfiguration> VERSIONING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Dataset.getter(Dataset::versioningConfiguration)).setter(Dataset.setter(Builder::versioningConfiguration)).constructor(VersioningConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versioningConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, ACTIONS_FIELD, TRIGGERS_FIELD, CONTENT_DELIVERY_RULES_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, RETENTION_PERIOD_FIELD, VERSIONING_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final List<DatasetAction> actions;
    private final List<DatasetTrigger> triggers;
    private final List<DatasetContentDeliveryRule> contentDeliveryRules;
    private final String status;
    private final Instant creationTime;
    private final Instant lastUpdateTime;
    private final RetentionPeriod retentionPeriod;
    private final VersioningConfiguration versioningConfiguration;

    private Dataset(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.actions = builder.actions;
        this.triggers = builder.triggers;
        this.contentDeliveryRules = builder.contentDeliveryRules;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.retentionPeriod = builder.retentionPeriod;
        this.versioningConfiguration = builder.versioningConfiguration;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public List<DatasetAction> actions() {
        return this.actions;
    }

    public boolean hasTriggers() {
        return this.triggers != null && !(this.triggers instanceof SdkAutoConstructList);
    }

    public List<DatasetTrigger> triggers() {
        return this.triggers;
    }

    public boolean hasContentDeliveryRules() {
        return this.contentDeliveryRules != null && !(this.contentDeliveryRules instanceof SdkAutoConstructList);
    }

    public List<DatasetContentDeliveryRule> contentDeliveryRules() {
        return this.contentDeliveryRules;
    }

    public DatasetStatus status() {
        return DatasetStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public RetentionPeriod retentionPeriod() {
        return this.retentionPeriod;
    }

    public VersioningConfiguration versioningConfiguration() {
        return this.versioningConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.actions());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggers());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentDeliveryRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.versioningConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dataset)) {
            return false;
        }
        Dataset other = (Dataset)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.triggers(), other.triggers()) && Objects.equals(this.contentDeliveryRules(), other.contentDeliveryRules()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && Objects.equals(this.versioningConfiguration(), other.versioningConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"Dataset").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Actions", this.actions()).add("Triggers", this.triggers()).add("ContentDeliveryRules", this.contentDeliveryRules()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("RetentionPeriod", (Object)this.retentionPeriod()).add("VersioningConfiguration", (Object)this.versioningConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "triggers": {
                return Optional.ofNullable(clazz.cast(this.triggers()));
            }
            case "contentDeliveryRules": {
                return Optional.ofNullable(clazz.cast(this.contentDeliveryRules()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "retentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "versioningConfiguration": {
                return Optional.ofNullable(clazz.cast(this.versioningConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Dataset, T> g) {
        return obj -> g.apply((Dataset)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private List<DatasetAction> actions = DefaultSdkAutoConstructList.getInstance();
        private List<DatasetTrigger> triggers = DefaultSdkAutoConstructList.getInstance();
        private List<DatasetContentDeliveryRule> contentDeliveryRules = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Instant creationTime;
        private Instant lastUpdateTime;
        private RetentionPeriod retentionPeriod;
        private VersioningConfiguration versioningConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Dataset model) {
            this.name(model.name);
            this.arn(model.arn);
            this.actions(model.actions);
            this.triggers(model.triggers);
            this.contentDeliveryRules(model.contentDeliveryRules);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.lastUpdateTime(model.lastUpdateTime);
            this.retentionPeriod(model.retentionPeriod);
            this.versioningConfiguration(model.versioningConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<DatasetAction.Builder> getActions() {
            return this.actions != null ? (Collection)this.actions.stream().map(DatasetAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<DatasetAction> actions) {
            this.actions = DatasetActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(DatasetAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<DatasetAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (DatasetAction)((DatasetAction.Builder)DatasetAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<DatasetAction.BuilderImpl> actions) {
            this.actions = DatasetActionsCopier.copyFromBuilder(actions);
        }

        public final Collection<DatasetTrigger.Builder> getTriggers() {
            return this.triggers != null ? (Collection)this.triggers.stream().map(DatasetTrigger::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder triggers(Collection<DatasetTrigger> triggers) {
            this.triggers = DatasetTriggersCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(DatasetTrigger ... triggers) {
            this.triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Consumer<DatasetTrigger.Builder> ... triggers) {
            this.triggers(Stream.of(triggers).map(c -> (DatasetTrigger)((DatasetTrigger.Builder)DatasetTrigger.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTriggers(Collection<DatasetTrigger.BuilderImpl> triggers) {
            this.triggers = DatasetTriggersCopier.copyFromBuilder(triggers);
        }

        public final Collection<DatasetContentDeliveryRule.Builder> getContentDeliveryRules() {
            return this.contentDeliveryRules != null ? (Collection)this.contentDeliveryRules.stream().map(DatasetContentDeliveryRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder contentDeliveryRules(Collection<DatasetContentDeliveryRule> contentDeliveryRules) {
            this.contentDeliveryRules = DatasetContentDeliveryRulesCopier.copy(contentDeliveryRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentDeliveryRules(DatasetContentDeliveryRule ... contentDeliveryRules) {
            this.contentDeliveryRules(Arrays.asList(contentDeliveryRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentDeliveryRules(Consumer<DatasetContentDeliveryRule.Builder> ... contentDeliveryRules) {
            this.contentDeliveryRules(Stream.of(contentDeliveryRules).map(c -> (DatasetContentDeliveryRule)((DatasetContentDeliveryRule.Builder)DatasetContentDeliveryRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContentDeliveryRules(Collection<DatasetContentDeliveryRule.BuilderImpl> contentDeliveryRules) {
            this.contentDeliveryRules = DatasetContentDeliveryRulesCopier.copyFromBuilder(contentDeliveryRules);
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DatasetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return this.retentionPeriod != null ? this.retentionPeriod.toBuilder() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        public final VersioningConfiguration.Builder getVersioningConfiguration() {
            return this.versioningConfiguration != null ? this.versioningConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder versioningConfiguration(VersioningConfiguration versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration;
            return this;
        }

        public final void setVersioningConfiguration(VersioningConfiguration.BuilderImpl versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration != null ? versioningConfiguration.build() : null;
        }

        public Dataset build() {
            return new Dataset(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Dataset> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder actions(Collection<DatasetAction> var1);

        public Builder actions(DatasetAction ... var1);

        public Builder actions(Consumer<DatasetAction.Builder> ... var1);

        public Builder triggers(Collection<DatasetTrigger> var1);

        public Builder triggers(DatasetTrigger ... var1);

        public Builder triggers(Consumer<DatasetTrigger.Builder> ... var1);

        public Builder contentDeliveryRules(Collection<DatasetContentDeliveryRule> var1);

        public Builder contentDeliveryRules(DatasetContentDeliveryRule ... var1);

        public Builder contentDeliveryRules(Consumer<DatasetContentDeliveryRule.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(DatasetStatus var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder retentionPeriod(RetentionPeriod var1);

        default public Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return this.retentionPeriod((RetentionPeriod)((RetentionPeriod.Builder)RetentionPeriod.builder().applyMutation(retentionPeriod)).build());
        }

        public Builder versioningConfiguration(VersioningConfiguration var1);

        default public Builder versioningConfiguration(Consumer<VersioningConfiguration.Builder> versioningConfiguration) {
            return this.versioningConfiguration((VersioningConfiguration)((VersioningConfiguration.Builder)VersioningConfiguration.builder().applyMutation(versioningConfiguration)).build());
        }
    }
}

