/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.CustomerManagedChannelS3StorageSummary;
import software.amazon.awssdk.services.iotanalytics.model.ServiceManagedChannelS3StorageSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelStorageSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChannelStorageSummary> {
    private static final SdkField<ServiceManagedChannelS3StorageSummary> SERVICE_MANAGED_S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceManagedS3").getter(ChannelStorageSummary.getter(ChannelStorageSummary::serviceManagedS3)).setter(ChannelStorageSummary.setter(Builder::serviceManagedS3)).constructor(ServiceManagedChannelS3StorageSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceManagedS3").build()}).build();
    private static final SdkField<CustomerManagedChannelS3StorageSummary> CUSTOMER_MANAGED_S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customerManagedS3").getter(ChannelStorageSummary.getter(ChannelStorageSummary::customerManagedS3)).setter(ChannelStorageSummary.setter(Builder::customerManagedS3)).constructor(CustomerManagedChannelS3StorageSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedS3").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_MANAGED_S3_FIELD, CUSTOMER_MANAGED_S3_FIELD));
    private static final long serialVersionUID = 1L;
    private final ServiceManagedChannelS3StorageSummary serviceManagedS3;
    private final CustomerManagedChannelS3StorageSummary customerManagedS3;

    private ChannelStorageSummary(BuilderImpl builder) {
        this.serviceManagedS3 = builder.serviceManagedS3;
        this.customerManagedS3 = builder.customerManagedS3;
    }

    public ServiceManagedChannelS3StorageSummary serviceManagedS3() {
        return this.serviceManagedS3;
    }

    public CustomerManagedChannelS3StorageSummary customerManagedS3() {
        return this.customerManagedS3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceManagedS3());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerManagedS3());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelStorageSummary)) {
            return false;
        }
        ChannelStorageSummary other = (ChannelStorageSummary)obj;
        return Objects.equals(this.serviceManagedS3(), other.serviceManagedS3()) && Objects.equals(this.customerManagedS3(), other.customerManagedS3());
    }

    public String toString() {
        return ToString.builder((String)"ChannelStorageSummary").add("ServiceManagedS3", (Object)this.serviceManagedS3()).add("CustomerManagedS3", (Object)this.customerManagedS3()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceManagedS3": {
                return Optional.ofNullable(clazz.cast(this.serviceManagedS3()));
            }
            case "customerManagedS3": {
                return Optional.ofNullable(clazz.cast(this.customerManagedS3()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelStorageSummary, T> g) {
        return obj -> g.apply((ChannelStorageSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ServiceManagedChannelS3StorageSummary serviceManagedS3;
        private CustomerManagedChannelS3StorageSummary customerManagedS3;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelStorageSummary model) {
            this.serviceManagedS3(model.serviceManagedS3);
            this.customerManagedS3(model.customerManagedS3);
        }

        public final ServiceManagedChannelS3StorageSummary.Builder getServiceManagedS3() {
            return this.serviceManagedS3 != null ? this.serviceManagedS3.toBuilder() : null;
        }

        @Override
        public final Builder serviceManagedS3(ServiceManagedChannelS3StorageSummary serviceManagedS3) {
            this.serviceManagedS3 = serviceManagedS3;
            return this;
        }

        public final void setServiceManagedS3(ServiceManagedChannelS3StorageSummary.BuilderImpl serviceManagedS3) {
            this.serviceManagedS3 = serviceManagedS3 != null ? serviceManagedS3.build() : null;
        }

        public final CustomerManagedChannelS3StorageSummary.Builder getCustomerManagedS3() {
            return this.customerManagedS3 != null ? this.customerManagedS3.toBuilder() : null;
        }

        @Override
        public final Builder customerManagedS3(CustomerManagedChannelS3StorageSummary customerManagedS3) {
            this.customerManagedS3 = customerManagedS3;
            return this;
        }

        public final void setCustomerManagedS3(CustomerManagedChannelS3StorageSummary.BuilderImpl customerManagedS3) {
            this.customerManagedS3 = customerManagedS3 != null ? customerManagedS3.build() : null;
        }

        public ChannelStorageSummary build() {
            return new ChannelStorageSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChannelStorageSummary> {
        public Builder serviceManagedS3(ServiceManagedChannelS3StorageSummary var1);

        default public Builder serviceManagedS3(Consumer<ServiceManagedChannelS3StorageSummary.Builder> serviceManagedS3) {
            return this.serviceManagedS3((ServiceManagedChannelS3StorageSummary)((ServiceManagedChannelS3StorageSummary.Builder)ServiceManagedChannelS3StorageSummary.builder().applyMutation(serviceManagedS3)).build());
        }

        public Builder customerManagedS3(CustomerManagedChannelS3StorageSummary var1);

        default public Builder customerManagedS3(Consumer<CustomerManagedChannelS3StorageSummary.Builder> customerManagedS3) {
            return this.customerManagedS3((CustomerManagedChannelS3StorageSummary)((CustomerManagedChannelS3StorageSummary.Builder)CustomerManagedChannelS3StorageSummary.builder().applyMutation(customerManagedS3)).build());
        }
    }
}

