/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.ChannelStatus;
import software.amazon.awssdk.services.iotanalytics.model.ChannelStorageSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChannelSummary> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelName").getter(ChannelSummary.getter(ChannelSummary::channelName)).setter(ChannelSummary.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()}).build();
    private static final SdkField<ChannelStorageSummary> CHANNEL_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("channelStorage").getter(ChannelSummary.getter(ChannelSummary::channelStorage)).setter(ChannelSummary.setter(Builder::channelStorage)).constructor(ChannelStorageSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelStorage").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ChannelSummary.getter(ChannelSummary::statusAsString)).setter(ChannelSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(ChannelSummary.getter(ChannelSummary::creationTime)).setter(ChannelSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(ChannelSummary.getter(ChannelSummary::lastUpdateTime)).setter(ChannelSummary.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD, CHANNEL_STORAGE_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String channelName;
    private final ChannelStorageSummary channelStorage;
    private final String status;
    private final Instant creationTime;
    private final Instant lastUpdateTime;

    private ChannelSummary(BuilderImpl builder) {
        this.channelName = builder.channelName;
        this.channelStorage = builder.channelStorage;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public String channelName() {
        return this.channelName;
    }

    public ChannelStorageSummary channelStorage() {
        return this.channelStorage;
    }

    public ChannelStatus status() {
        return ChannelStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelSummary)) {
            return false;
        }
        ChannelSummary other = (ChannelSummary)obj;
        return Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.channelStorage(), other.channelStorage()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime());
    }

    public String toString() {
        return ToString.builder((String)"ChannelSummary").add("ChannelName", (Object)this.channelName()).add("ChannelStorage", (Object)this.channelStorage()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "channelStorage": {
                return Optional.ofNullable(clazz.cast(this.channelStorage()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelSummary, T> g) {
        return obj -> g.apply((ChannelSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channelName;
        private ChannelStorageSummary channelStorage;
        private String status;
        private Instant creationTime;
        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelSummary model) {
            this.channelName(model.channelName);
            this.channelStorage(model.channelStorage);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.lastUpdateTime(model.lastUpdateTime);
        }

        public final String getChannelName() {
            return this.channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public final ChannelStorageSummary.Builder getChannelStorage() {
            return this.channelStorage != null ? this.channelStorage.toBuilder() : null;
        }

        @Override
        public final Builder channelStorage(ChannelStorageSummary channelStorage) {
            this.channelStorage = channelStorage;
            return this;
        }

        public final void setChannelStorage(ChannelStorageSummary.BuilderImpl channelStorage) {
            this.channelStorage = channelStorage != null ? channelStorage.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChannelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public ChannelSummary build() {
            return new ChannelSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChannelSummary> {
        public Builder channelName(String var1);

        public Builder channelStorage(ChannelStorageSummary var1);

        default public Builder channelStorage(Consumer<ChannelStorageSummary.Builder> channelStorage) {
            return this.channelStorage((ChannelStorageSummary)((ChannelStorageSummary.Builder)ChannelStorageSummary.builder().applyMutation(channelStorage)).build());
        }

        public Builder status(String var1);

        public Builder status(ChannelStatus var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);
    }
}

