/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotanalytics.model.ResourceConfiguration;
import software.amazon.awssdk.services.iotanalytics.model.Variable;
import software.amazon.awssdk.services.iotanalytics.model.VariablesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerDatasetAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerDatasetAction> {
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("image").getter(ContainerDatasetAction.getter(ContainerDatasetAction::image)).setter(ContainerDatasetAction.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRoleArn").getter(ContainerDatasetAction.getter(ContainerDatasetAction::executionRoleArn)).setter(ContainerDatasetAction.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final SdkField<ResourceConfiguration> RESOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourceConfiguration").getter(ContainerDatasetAction.getter(ContainerDatasetAction::resourceConfiguration)).setter(ContainerDatasetAction.setter(Builder::resourceConfiguration)).constructor(ResourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfiguration").build()}).build();
    private static final SdkField<List<Variable>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variables").getter(ContainerDatasetAction.getter(ContainerDatasetAction::variables)).setter(ContainerDatasetAction.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Variable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD, EXECUTION_ROLE_ARN_FIELD, RESOURCE_CONFIGURATION_FIELD, VARIABLES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String image;
    private final String executionRoleArn;
    private final ResourceConfiguration resourceConfiguration;
    private final List<Variable> variables;

    private ContainerDatasetAction(BuilderImpl builder) {
        this.image = builder.image;
        this.executionRoleArn = builder.executionRoleArn;
        this.resourceConfiguration = builder.resourceConfiguration;
        this.variables = builder.variables;
    }

    public String image() {
        return this.image;
    }

    public String executionRoleArn() {
        return this.executionRoleArn;
    }

    public ResourceConfiguration resourceConfiguration() {
        return this.resourceConfiguration;
    }

    public boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructList);
    }

    public List<Variable> variables() {
        return this.variables;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariables() ? this.variables() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDatasetAction)) {
            return false;
        }
        ContainerDatasetAction other = (ContainerDatasetAction)obj;
        return Objects.equals(this.image(), other.image()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.resourceConfiguration(), other.resourceConfiguration()) && this.hasVariables() == other.hasVariables() && Objects.equals(this.variables(), other.variables());
    }

    public String toString() {
        return ToString.builder((String)"ContainerDatasetAction").add("Image", (Object)this.image()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("ResourceConfiguration", (Object)this.resourceConfiguration()).add("Variables", this.hasVariables() ? this.variables() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "resourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.resourceConfiguration()));
            }
            case "variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerDatasetAction, T> g) {
        return obj -> g.apply((ContainerDatasetAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String image;
        private String executionRoleArn;
        private ResourceConfiguration resourceConfiguration;
        private List<Variable> variables = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerDatasetAction model) {
            this.image(model.image);
            this.executionRoleArn(model.executionRoleArn);
            this.resourceConfiguration(model.resourceConfiguration);
            this.variables(model.variables);
        }

        public final String getImage() {
            return this.image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final ResourceConfiguration.Builder getResourceConfiguration() {
            return this.resourceConfiguration != null ? this.resourceConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder resourceConfiguration(ResourceConfiguration resourceConfiguration) {
            this.resourceConfiguration = resourceConfiguration;
            return this;
        }

        public final void setResourceConfiguration(ResourceConfiguration.BuilderImpl resourceConfiguration) {
            this.resourceConfiguration = resourceConfiguration != null ? resourceConfiguration.build() : null;
        }

        public final Collection<Variable.Builder> getVariables() {
            if (this.variables instanceof SdkAutoConstructList) {
                return null;
            }
            return this.variables != null ? (Collection)this.variables.stream().map(Variable::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder variables(Collection<Variable> variables) {
            this.variables = VariablesCopier.copy(variables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Variable ... variables) {
            this.variables(Arrays.asList(variables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Consumer<Variable.Builder> ... variables) {
            this.variables(Stream.of(variables).map(c -> (Variable)((Variable.Builder)Variable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVariables(Collection<Variable.BuilderImpl> variables) {
            this.variables = VariablesCopier.copyFromBuilder(variables);
        }

        public ContainerDatasetAction build() {
            return new ContainerDatasetAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerDatasetAction> {
        public Builder image(String var1);

        public Builder executionRoleArn(String var1);

        public Builder resourceConfiguration(ResourceConfiguration var1);

        default public Builder resourceConfiguration(Consumer<ResourceConfiguration.Builder> resourceConfiguration) {
            return this.resourceConfiguration((ResourceConfiguration)((ResourceConfiguration.Builder)ResourceConfiguration.builder().applyMutation(resourceConfiguration)).build());
        }

        public Builder variables(Collection<Variable> var1);

        public Builder variables(Variable ... var1);

        public Builder variables(Consumer<Variable.Builder> ... var1);
    }
}

