/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatasetEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatasetEntry> {
    private static final SdkField<String> ENTRY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entryName").getter(DatasetEntry.getter(DatasetEntry::entryName)).setter(DatasetEntry.setter(Builder::entryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryName").build()}).build();
    private static final SdkField<String> DATA_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataURI").getter(DatasetEntry.getter(DatasetEntry::dataURI)).setter(DatasetEntry.setter(Builder::dataURI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataURI").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_NAME_FIELD, DATA_URI_FIELD));
    private static final long serialVersionUID = 1L;
    private final String entryName;
    private final String dataURI;

    private DatasetEntry(BuilderImpl builder) {
        this.entryName = builder.entryName;
        this.dataURI = builder.dataURI;
    }

    public String entryName() {
        return this.entryName;
    }

    public String dataURI() {
        return this.dataURI;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataURI());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetEntry)) {
            return false;
        }
        DatasetEntry other = (DatasetEntry)obj;
        return Objects.equals(this.entryName(), other.entryName()) && Objects.equals(this.dataURI(), other.dataURI());
    }

    public String toString() {
        return ToString.builder((String)"DatasetEntry").add("EntryName", (Object)this.entryName()).add("DataURI", (Object)this.dataURI()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entryName": {
                return Optional.ofNullable(clazz.cast(this.entryName()));
            }
            case "dataURI": {
                return Optional.ofNullable(clazz.cast(this.dataURI()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetEntry, T> g) {
        return obj -> g.apply((DatasetEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entryName;
        private String dataURI;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetEntry model) {
            this.entryName(model.entryName);
            this.dataURI(model.dataURI);
        }

        public final String getEntryName() {
            return this.entryName;
        }

        @Override
        public final Builder entryName(String entryName) {
            this.entryName = entryName;
            return this;
        }

        public final void setEntryName(String entryName) {
            this.entryName = entryName;
        }

        public final String getDataURI() {
            return this.dataURI;
        }

        @Override
        public final Builder dataURI(String dataURI) {
            this.dataURI = dataURI;
            return this;
        }

        public final void setDataURI(String dataURI) {
            this.dataURI = dataURI;
        }

        public DatasetEntry build() {
            return new DatasetEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatasetEntry> {
        public Builder entryName(String var1);

        public Builder dataURI(String var1);
    }
}

