/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePipelineResponse
extends IoTAnalyticsResponse
implements ToCopyableBuilder<Builder, CreatePipelineResponse> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineName").getter(CreatePipelineResponse.getter(CreatePipelineResponse::pipelineName)).setter(CreatePipelineResponse.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()}).build();
    private static final SdkField<String> PIPELINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineArn").getter(CreatePipelineResponse.getter(CreatePipelineResponse::pipelineArn)).setter(CreatePipelineResponse.setter(Builder::pipelineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD, PIPELINE_ARN_FIELD));
    private final String pipelineName;
    private final String pipelineArn;

    private CreatePipelineResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.pipelineArn = builder.pipelineArn;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public String pipelineArn() {
        return this.pipelineArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePipelineResponse)) {
            return false;
        }
        CreatePipelineResponse other = (CreatePipelineResponse)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.pipelineArn(), other.pipelineArn());
    }

    public String toString() {
        return ToString.builder((String)"CreatePipelineResponse").add("PipelineName", (Object)this.pipelineName()).add("PipelineArn", (Object)this.pipelineArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "pipelineArn": {
                return Optional.ofNullable(clazz.cast(this.pipelineArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePipelineResponse, T> g) {
        return obj -> g.apply((CreatePipelineResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTAnalyticsResponse.BuilderImpl
    implements Builder {
        private String pipelineName;
        private String pipelineArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePipelineResponse model) {
            super(model);
            this.pipelineName(model.pipelineName);
            this.pipelineArn(model.pipelineArn);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final String getPipelineArn() {
            return this.pipelineArn;
        }

        @Override
        public final Builder pipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
            return this;
        }

        public final void setPipelineArn(String pipelineArn) {
            this.pipelineArn = pipelineArn;
        }

        @Override
        public CreatePipelineResponse build() {
            return new CreatePipelineResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTAnalyticsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePipelineResponse> {
        public Builder pipelineName(String var1);

        public Builder pipelineArn(String var1);
    }
}

