/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.CustomerManagedDatastoreS3Storage;
import software.amazon.awssdk.services.iotanalytics.model.ServiceManagedDatastoreS3Storage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatastoreStorage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatastoreStorage> {
    private static final SdkField<ServiceManagedDatastoreS3Storage> SERVICE_MANAGED_S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceManagedS3").getter(DatastoreStorage.getter(DatastoreStorage::serviceManagedS3)).setter(DatastoreStorage.setter(Builder::serviceManagedS3)).constructor(ServiceManagedDatastoreS3Storage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceManagedS3").build()}).build();
    private static final SdkField<CustomerManagedDatastoreS3Storage> CUSTOMER_MANAGED_S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customerManagedS3").getter(DatastoreStorage.getter(DatastoreStorage::customerManagedS3)).setter(DatastoreStorage.setter(Builder::customerManagedS3)).constructor(CustomerManagedDatastoreS3Storage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedS3").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_MANAGED_S3_FIELD, CUSTOMER_MANAGED_S3_FIELD));
    private static final long serialVersionUID = 1L;
    private final ServiceManagedDatastoreS3Storage serviceManagedS3;
    private final CustomerManagedDatastoreS3Storage customerManagedS3;

    private DatastoreStorage(BuilderImpl builder) {
        this.serviceManagedS3 = builder.serviceManagedS3;
        this.customerManagedS3 = builder.customerManagedS3;
    }

    public ServiceManagedDatastoreS3Storage serviceManagedS3() {
        return this.serviceManagedS3;
    }

    public CustomerManagedDatastoreS3Storage customerManagedS3() {
        return this.customerManagedS3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceManagedS3());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerManagedS3());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastoreStorage)) {
            return false;
        }
        DatastoreStorage other = (DatastoreStorage)obj;
        return Objects.equals(this.serviceManagedS3(), other.serviceManagedS3()) && Objects.equals(this.customerManagedS3(), other.customerManagedS3());
    }

    public String toString() {
        return ToString.builder((String)"DatastoreStorage").add("ServiceManagedS3", (Object)this.serviceManagedS3()).add("CustomerManagedS3", (Object)this.customerManagedS3()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceManagedS3": {
                return Optional.ofNullable(clazz.cast(this.serviceManagedS3()));
            }
            case "customerManagedS3": {
                return Optional.ofNullable(clazz.cast(this.customerManagedS3()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatastoreStorage, T> g) {
        return obj -> g.apply((DatastoreStorage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ServiceManagedDatastoreS3Storage serviceManagedS3;
        private CustomerManagedDatastoreS3Storage customerManagedS3;

        private BuilderImpl() {
        }

        private BuilderImpl(DatastoreStorage model) {
            this.serviceManagedS3(model.serviceManagedS3);
            this.customerManagedS3(model.customerManagedS3);
        }

        public final ServiceManagedDatastoreS3Storage.Builder getServiceManagedS3() {
            return this.serviceManagedS3 != null ? this.serviceManagedS3.toBuilder() : null;
        }

        @Override
        public final Builder serviceManagedS3(ServiceManagedDatastoreS3Storage serviceManagedS3) {
            this.serviceManagedS3 = serviceManagedS3;
            return this;
        }

        public final void setServiceManagedS3(ServiceManagedDatastoreS3Storage.BuilderImpl serviceManagedS3) {
            this.serviceManagedS3 = serviceManagedS3 != null ? serviceManagedS3.build() : null;
        }

        public final CustomerManagedDatastoreS3Storage.Builder getCustomerManagedS3() {
            return this.customerManagedS3 != null ? this.customerManagedS3.toBuilder() : null;
        }

        @Override
        public final Builder customerManagedS3(CustomerManagedDatastoreS3Storage customerManagedS3) {
            this.customerManagedS3 = customerManagedS3;
            return this;
        }

        public final void setCustomerManagedS3(CustomerManagedDatastoreS3Storage.BuilderImpl customerManagedS3) {
            this.customerManagedS3 = customerManagedS3 != null ? customerManagedS3.build() : null;
        }

        public DatastoreStorage build() {
            return new DatastoreStorage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatastoreStorage> {
        public Builder serviceManagedS3(ServiceManagedDatastoreS3Storage var1);

        default public Builder serviceManagedS3(Consumer<ServiceManagedDatastoreS3Storage.Builder> serviceManagedS3) {
            return this.serviceManagedS3((ServiceManagedDatastoreS3Storage)((ServiceManagedDatastoreS3Storage.Builder)ServiceManagedDatastoreS3Storage.builder().applyMutation(serviceManagedS3)).build());
        }

        public Builder customerManagedS3(CustomerManagedDatastoreS3Storage var1);

        default public Builder customerManagedS3(Consumer<CustomerManagedDatastoreS3Storage.Builder> customerManagedS3) {
            return this.customerManagedS3((CustomerManagedDatastoreS3Storage)((CustomerManagedDatastoreS3Storage.Builder)CustomerManagedDatastoreS3Storage.builder().applyMutation(customerManagedS3)).build());
        }
    }
}

