/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.DatastoreStatus;
import software.amazon.awssdk.services.iotanalytics.model.DatastoreStorageSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatastoreSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatastoreSummary> {
    private static final SdkField<String> DATASTORE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datastoreName").getter(DatastoreSummary.getter(DatastoreSummary::datastoreName)).setter(DatastoreSummary.setter(Builder::datastoreName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreName").build()}).build();
    private static final SdkField<DatastoreStorageSummary> DATASTORE_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("datastoreStorage").getter(DatastoreSummary.getter(DatastoreSummary::datastoreStorage)).setter(DatastoreSummary.setter(Builder::datastoreStorage)).constructor(DatastoreStorageSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreStorage").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DatastoreSummary.getter(DatastoreSummary::statusAsString)).setter(DatastoreSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(DatastoreSummary.getter(DatastoreSummary::creationTime)).setter(DatastoreSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(DatastoreSummary.getter(DatastoreSummary::lastUpdateTime)).setter(DatastoreSummary.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final SdkField<Instant> LAST_MESSAGE_ARRIVAL_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastMessageArrivalTime").getter(DatastoreSummary.getter(DatastoreSummary::lastMessageArrivalTime)).setter(DatastoreSummary.setter(Builder::lastMessageArrivalTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastMessageArrivalTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_NAME_FIELD, DATASTORE_STORAGE_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, LAST_MESSAGE_ARRIVAL_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String datastoreName;
    private final DatastoreStorageSummary datastoreStorage;
    private final String status;
    private final Instant creationTime;
    private final Instant lastUpdateTime;
    private final Instant lastMessageArrivalTime;

    private DatastoreSummary(BuilderImpl builder) {
        this.datastoreName = builder.datastoreName;
        this.datastoreStorage = builder.datastoreStorage;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.lastMessageArrivalTime = builder.lastMessageArrivalTime;
    }

    public String datastoreName() {
        return this.datastoreName;
    }

    public DatastoreStorageSummary datastoreStorage() {
        return this.datastoreStorage;
    }

    public DatastoreStatus status() {
        return DatastoreStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Instant lastMessageArrivalTime() {
        return this.lastMessageArrivalTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastMessageArrivalTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastoreSummary)) {
            return false;
        }
        DatastoreSummary other = (DatastoreSummary)obj;
        return Objects.equals(this.datastoreName(), other.datastoreName()) && Objects.equals(this.datastoreStorage(), other.datastoreStorage()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.lastMessageArrivalTime(), other.lastMessageArrivalTime());
    }

    public String toString() {
        return ToString.builder((String)"DatastoreSummary").add("DatastoreName", (Object)this.datastoreName()).add("DatastoreStorage", (Object)this.datastoreStorage()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("LastMessageArrivalTime", (Object)this.lastMessageArrivalTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datastoreName": {
                return Optional.ofNullable(clazz.cast(this.datastoreName()));
            }
            case "datastoreStorage": {
                return Optional.ofNullable(clazz.cast(this.datastoreStorage()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "lastMessageArrivalTime": {
                return Optional.ofNullable(clazz.cast(this.lastMessageArrivalTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatastoreSummary, T> g) {
        return obj -> g.apply((DatastoreSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String datastoreName;
        private DatastoreStorageSummary datastoreStorage;
        private String status;
        private Instant creationTime;
        private Instant lastUpdateTime;
        private Instant lastMessageArrivalTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DatastoreSummary model) {
            this.datastoreName(model.datastoreName);
            this.datastoreStorage(model.datastoreStorage);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.lastUpdateTime(model.lastUpdateTime);
            this.lastMessageArrivalTime(model.lastMessageArrivalTime);
        }

        public final String getDatastoreName() {
            return this.datastoreName;
        }

        @Override
        public final Builder datastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        public final void setDatastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
        }

        public final DatastoreStorageSummary.Builder getDatastoreStorage() {
            return this.datastoreStorage != null ? this.datastoreStorage.toBuilder() : null;
        }

        @Override
        public final Builder datastoreStorage(DatastoreStorageSummary datastoreStorage) {
            this.datastoreStorage = datastoreStorage;
            return this;
        }

        public final void setDatastoreStorage(DatastoreStorageSummary.BuilderImpl datastoreStorage) {
            this.datastoreStorage = datastoreStorage != null ? datastoreStorage.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DatastoreStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public final Instant getLastMessageArrivalTime() {
            return this.lastMessageArrivalTime;
        }

        @Override
        public final Builder lastMessageArrivalTime(Instant lastMessageArrivalTime) {
            this.lastMessageArrivalTime = lastMessageArrivalTime;
            return this;
        }

        public final void setLastMessageArrivalTime(Instant lastMessageArrivalTime) {
            this.lastMessageArrivalTime = lastMessageArrivalTime;
        }

        public DatastoreSummary build() {
            return new DatastoreSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatastoreSummary> {
        public Builder datastoreName(String var1);

        public Builder datastoreStorage(DatastoreStorageSummary var1);

        default public Builder datastoreStorage(Consumer<DatastoreStorageSummary.Builder> datastoreStorage) {
            return this.datastoreStorage((DatastoreStorageSummary)((DatastoreStorageSummary.Builder)DatastoreStorageSummary.builder().applyMutation(datastoreStorage)).build());
        }

        public Builder status(String var1);

        public Builder status(DatastoreStatus var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder lastMessageArrivalTime(Instant var1);
    }
}

