/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotanalytics.model.DatasetContentStatus;
import software.amazon.awssdk.services.iotanalytics.model.DatasetEntriesCopier;
import software.amazon.awssdk.services.iotanalytics.model.DatasetEntry;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDatasetContentResponse
extends IoTAnalyticsResponse
implements ToCopyableBuilder<Builder, GetDatasetContentResponse> {
    private static final SdkField<List<DatasetEntry>> ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entries").getter(GetDatasetContentResponse.getter(GetDatasetContentResponse::entries)).setter(GetDatasetContentResponse.setter(Builder::entries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timestamp").getter(GetDatasetContentResponse.getter(GetDatasetContentResponse::timestamp)).setter(GetDatasetContentResponse.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<DatasetContentStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(GetDatasetContentResponse.getter(GetDatasetContentResponse::status)).setter(GetDatasetContentResponse.setter(Builder::status)).constructor(DatasetContentStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRIES_FIELD, TIMESTAMP_FIELD, STATUS_FIELD));
    private final List<DatasetEntry> entries;
    private final Instant timestamp;
    private final DatasetContentStatus status;

    private GetDatasetContentResponse(BuilderImpl builder) {
        super(builder);
        this.entries = builder.entries;
        this.timestamp = builder.timestamp;
        this.status = builder.status;
    }

    public boolean hasEntries() {
        return this.entries != null && !(this.entries instanceof SdkAutoConstructList);
    }

    public List<DatasetEntry> entries() {
        return this.entries;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public DatasetContentStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntries() ? this.entries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDatasetContentResponse)) {
            return false;
        }
        GetDatasetContentResponse other = (GetDatasetContentResponse)((Object)obj);
        return this.hasEntries() == other.hasEntries() && Objects.equals(this.entries(), other.entries()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"GetDatasetContentResponse").add("Entries", this.hasEntries() ? this.entries() : null).add("Timestamp", (Object)this.timestamp()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entries": {
                return Optional.ofNullable(clazz.cast(this.entries()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDatasetContentResponse, T> g) {
        return obj -> g.apply((GetDatasetContentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTAnalyticsResponse.BuilderImpl
    implements Builder {
        private List<DatasetEntry> entries = DefaultSdkAutoConstructList.getInstance();
        private Instant timestamp;
        private DatasetContentStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDatasetContentResponse model) {
            super(model);
            this.entries(model.entries);
            this.timestamp(model.timestamp);
            this.status(model.status);
        }

        public final Collection<DatasetEntry.Builder> getEntries() {
            if (this.entries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entries != null ? (Collection)this.entries.stream().map(DatasetEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entries(Collection<DatasetEntry> entries) {
            this.entries = DatasetEntriesCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(DatasetEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<DatasetEntry.Builder> ... entries) {
            this.entries(Stream.of(entries).map(c -> (DatasetEntry)((DatasetEntry.Builder)DatasetEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEntries(Collection<DatasetEntry.BuilderImpl> entries) {
            this.entries = DatasetEntriesCopier.copyFromBuilder(entries);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final DatasetContentStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(DatasetContentStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(DatasetContentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public GetDatasetContentResponse build() {
            return new GetDatasetContentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTAnalyticsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDatasetContentResponse> {
        public Builder entries(Collection<DatasetEntry> var1);

        public Builder entries(DatasetEntry ... var1);

        public Builder entries(Consumer<DatasetEntry.Builder> ... var1);

        public Builder timestamp(Instant var1);

        public Builder status(DatasetContentStatus var1);

        default public Builder status(Consumer<DatasetContentStatus.Builder> status) {
            return this.status((DatasetContentStatus)((DatasetContentStatus.Builder)DatasetContentStatus.builder().applyMutation(status)).build());
        }
    }
}

