/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotanalytics.model.PipelineActivitiesCopier;
import software.amazon.awssdk.services.iotanalytics.model.PipelineActivity;
import software.amazon.awssdk.services.iotanalytics.model.ReprocessingSummariesCopier;
import software.amazon.awssdk.services.iotanalytics.model.ReprocessingSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Pipeline
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Pipeline> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Pipeline.getter(Pipeline::name)).setter(Pipeline.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Pipeline.getter(Pipeline::arn)).setter(Pipeline.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<PipelineActivity>> ACTIVITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("activities").getter(Pipeline.getter(Pipeline::activities)).setter(Pipeline.setter(Builder::activities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PipelineActivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ReprocessingSummary>> REPROCESSING_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reprocessingSummaries").getter(Pipeline.getter(Pipeline::reprocessingSummaries)).setter(Pipeline.setter(Builder::reprocessingSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reprocessingSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReprocessingSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(Pipeline.getter(Pipeline::creationTime)).setter(Pipeline.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(Pipeline.getter(Pipeline::lastUpdateTime)).setter(Pipeline.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, ACTIVITIES_FIELD, REPROCESSING_SUMMARIES_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final List<PipelineActivity> activities;
    private final List<ReprocessingSummary> reprocessingSummaries;
    private final Instant creationTime;
    private final Instant lastUpdateTime;

    private Pipeline(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.activities = builder.activities;
        this.reprocessingSummaries = builder.reprocessingSummaries;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public boolean hasActivities() {
        return this.activities != null && !(this.activities instanceof SdkAutoConstructList);
    }

    public List<PipelineActivity> activities() {
        return this.activities;
    }

    public boolean hasReprocessingSummaries() {
        return this.reprocessingSummaries != null && !(this.reprocessingSummaries instanceof SdkAutoConstructList);
    }

    public List<ReprocessingSummary> reprocessingSummaries() {
        return this.reprocessingSummaries;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActivities() ? this.activities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReprocessingSummaries() ? this.reprocessingSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pipeline)) {
            return false;
        }
        Pipeline other = (Pipeline)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && this.hasActivities() == other.hasActivities() && Objects.equals(this.activities(), other.activities()) && this.hasReprocessingSummaries() == other.hasReprocessingSummaries() && Objects.equals(this.reprocessingSummaries(), other.reprocessingSummaries()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime());
    }

    public String toString() {
        return ToString.builder((String)"Pipeline").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Activities", this.hasActivities() ? this.activities() : null).add("ReprocessingSummaries", this.hasReprocessingSummaries() ? this.reprocessingSummaries() : null).add("CreationTime", (Object)this.creationTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "activities": {
                return Optional.ofNullable(clazz.cast(this.activities()));
            }
            case "reprocessingSummaries": {
                return Optional.ofNullable(clazz.cast(this.reprocessingSummaries()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Pipeline, T> g) {
        return obj -> g.apply((Pipeline)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private List<PipelineActivity> activities = DefaultSdkAutoConstructList.getInstance();
        private List<ReprocessingSummary> reprocessingSummaries = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTime;
        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Pipeline model) {
            this.name(model.name);
            this.arn(model.arn);
            this.activities(model.activities);
            this.reprocessingSummaries(model.reprocessingSummaries);
            this.creationTime(model.creationTime);
            this.lastUpdateTime(model.lastUpdateTime);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<PipelineActivity.Builder> getActivities() {
            if (this.activities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.activities != null ? (Collection)this.activities.stream().map(PipelineActivity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder activities(Collection<PipelineActivity> activities) {
            this.activities = PipelineActivitiesCopier.copy(activities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activities(PipelineActivity ... activities) {
            this.activities(Arrays.asList(activities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activities(Consumer<PipelineActivity.Builder> ... activities) {
            this.activities(Stream.of(activities).map(c -> (PipelineActivity)((PipelineActivity.Builder)PipelineActivity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActivities(Collection<PipelineActivity.BuilderImpl> activities) {
            this.activities = PipelineActivitiesCopier.copyFromBuilder(activities);
        }

        public final Collection<ReprocessingSummary.Builder> getReprocessingSummaries() {
            if (this.reprocessingSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reprocessingSummaries != null ? (Collection)this.reprocessingSummaries.stream().map(ReprocessingSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reprocessingSummaries(Collection<ReprocessingSummary> reprocessingSummaries) {
            this.reprocessingSummaries = ReprocessingSummariesCopier.copy(reprocessingSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reprocessingSummaries(ReprocessingSummary ... reprocessingSummaries) {
            this.reprocessingSummaries(Arrays.asList(reprocessingSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reprocessingSummaries(Consumer<ReprocessingSummary.Builder> ... reprocessingSummaries) {
            this.reprocessingSummaries(Stream.of(reprocessingSummaries).map(c -> (ReprocessingSummary)((ReprocessingSummary.Builder)ReprocessingSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReprocessingSummaries(Collection<ReprocessingSummary.BuilderImpl> reprocessingSummaries) {
            this.reprocessingSummaries = ReprocessingSummariesCopier.copyFromBuilder(reprocessingSummaries);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public Pipeline build() {
            return new Pipeline(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Pipeline> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder activities(Collection<PipelineActivity> var1);

        public Builder activities(PipelineActivity ... var1);

        public Builder activities(Consumer<PipelineActivity.Builder> ... var1);

        public Builder reprocessingSummaries(Collection<ReprocessingSummary> var1);

        public Builder reprocessingSummaries(ReprocessingSummary ... var1);

        public Builder reprocessingSummaries(Consumer<ReprocessingSummary.Builder> ... var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);
    }
}

