/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.DatastoreStorage;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsRequest;
import software.amazon.awssdk.services.iotanalytics.model.RetentionPeriod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDatastoreRequest
extends IoTAnalyticsRequest
implements ToCopyableBuilder<Builder, UpdateDatastoreRequest> {
    private static final SdkField<String> DATASTORE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datastoreName").getter(UpdateDatastoreRequest.getter(UpdateDatastoreRequest::datastoreName)).setter(UpdateDatastoreRequest.setter(Builder::datastoreName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("datastoreName").build()}).build();
    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retentionPeriod").getter(UpdateDatastoreRequest.getter(UpdateDatastoreRequest::retentionPeriod)).setter(UpdateDatastoreRequest.setter(Builder::retentionPeriod)).constructor(RetentionPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()}).build();
    private static final SdkField<DatastoreStorage> DATASTORE_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("datastoreStorage").getter(UpdateDatastoreRequest.getter(UpdateDatastoreRequest::datastoreStorage)).setter(UpdateDatastoreRequest.setter(Builder::datastoreStorage)).constructor(DatastoreStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreStorage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_NAME_FIELD, RETENTION_PERIOD_FIELD, DATASTORE_STORAGE_FIELD));
    private final String datastoreName;
    private final RetentionPeriod retentionPeriod;
    private final DatastoreStorage datastoreStorage;

    private UpdateDatastoreRequest(BuilderImpl builder) {
        super(builder);
        this.datastoreName = builder.datastoreName;
        this.retentionPeriod = builder.retentionPeriod;
        this.datastoreStorage = builder.datastoreStorage;
    }

    public String datastoreName() {
        return this.datastoreName;
    }

    public RetentionPeriod retentionPeriod() {
        return this.retentionPeriod;
    }

    public DatastoreStorage datastoreStorage() {
        return this.datastoreStorage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreName());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreStorage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatastoreRequest)) {
            return false;
        }
        UpdateDatastoreRequest other = (UpdateDatastoreRequest)((Object)obj);
        return Objects.equals(this.datastoreName(), other.datastoreName()) && Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && Objects.equals(this.datastoreStorage(), other.datastoreStorage());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDatastoreRequest").add("DatastoreName", (Object)this.datastoreName()).add("RetentionPeriod", (Object)this.retentionPeriod()).add("DatastoreStorage", (Object)this.datastoreStorage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datastoreName": {
                return Optional.ofNullable(clazz.cast(this.datastoreName()));
            }
            case "retentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "datastoreStorage": {
                return Optional.ofNullable(clazz.cast(this.datastoreStorage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDatastoreRequest, T> g) {
        return obj -> g.apply((UpdateDatastoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTAnalyticsRequest.BuilderImpl
    implements Builder {
        private String datastoreName;
        private RetentionPeriod retentionPeriod;
        private DatastoreStorage datastoreStorage;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDatastoreRequest model) {
            super(model);
            this.datastoreName(model.datastoreName);
            this.retentionPeriod(model.retentionPeriod);
            this.datastoreStorage(model.datastoreStorage);
        }

        public final String getDatastoreName() {
            return this.datastoreName;
        }

        @Override
        public final Builder datastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        public final void setDatastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return this.retentionPeriod != null ? this.retentionPeriod.toBuilder() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        public final DatastoreStorage.Builder getDatastoreStorage() {
            return this.datastoreStorage != null ? this.datastoreStorage.toBuilder() : null;
        }

        @Override
        public final Builder datastoreStorage(DatastoreStorage datastoreStorage) {
            this.datastoreStorage = datastoreStorage;
            return this;
        }

        public final void setDatastoreStorage(DatastoreStorage.BuilderImpl datastoreStorage) {
            this.datastoreStorage = datastoreStorage != null ? datastoreStorage.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDatastoreRequest build() {
            return new UpdateDatastoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTAnalyticsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDatastoreRequest> {
        public Builder datastoreName(String var1);

        public Builder retentionPeriod(RetentionPeriod var1);

        default public Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return this.retentionPeriod((RetentionPeriod)((RetentionPeriod.Builder)RetentionPeriod.builder().applyMutation(retentionPeriod)).build());
        }

        public Builder datastoreStorage(DatastoreStorage var1);

        default public Builder datastoreStorage(Consumer<DatastoreStorage.Builder> datastoreStorage) {
            return this.datastoreStorage((DatastoreStorage)((DatastoreStorage.Builder)DatastoreStorage.builder().applyMutation(datastoreStorage)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

