/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotanalytics.model.S3PathChannelMessagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelMessages
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChannelMessages> {
    private static final SdkField<List<String>> S3_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("s3Paths").getter(ChannelMessages.getter(ChannelMessages::s3Paths)).setter(ChannelMessages.setter(Builder::s3Paths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Paths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_PATHS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> s3Paths;

    private ChannelMessages(BuilderImpl builder) {
        this.s3Paths = builder.s3Paths;
    }

    public final boolean hasS3Paths() {
        return this.s3Paths != null && !(this.s3Paths instanceof SdkAutoConstructList);
    }

    public final List<String> s3Paths() {
        return this.s3Paths;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasS3Paths() ? this.s3Paths() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelMessages)) {
            return false;
        }
        ChannelMessages other = (ChannelMessages)obj;
        return this.hasS3Paths() == other.hasS3Paths() && Objects.equals(this.s3Paths(), other.s3Paths());
    }

    public final String toString() {
        return ToString.builder((String)"ChannelMessages").add("S3Paths", this.hasS3Paths() ? this.s3Paths() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3Paths": {
                return Optional.ofNullable(clazz.cast(this.s3Paths()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelMessages, T> g) {
        return obj -> g.apply((ChannelMessages)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> s3Paths = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelMessages model) {
            this.s3Paths(model.s3Paths);
        }

        public final Collection<String> getS3Paths() {
            if (this.s3Paths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.s3Paths;
        }

        @Override
        public final Builder s3Paths(Collection<String> s3Paths) {
            this.s3Paths = S3PathChannelMessagesCopier.copy(s3Paths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Paths(String ... s3Paths) {
            this.s3Paths(Arrays.asList(s3Paths));
            return this;
        }

        public final void setS3Paths(Collection<String> s3Paths) {
            this.s3Paths = S3PathChannelMessagesCopier.copy(s3Paths);
        }

        public ChannelMessages build() {
            return new ChannelMessages(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChannelMessages> {
        public Builder s3Paths(Collection<String> var1);

        public Builder s3Paths(String ... var1);
    }
}

