/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Where channel data is stored. You may choose one of <code>serviceManagedS3</code> or <code>customerManagedS3</code>
 * storage. If not specified, the default is <code>serviceManagedS3</code>. This cannot be changed after creation of the
 * channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelStorage implements SdkPojo, Serializable, ToCopyableBuilder<ChannelStorage.Builder, ChannelStorage> {
    private static final SdkField<ServiceManagedChannelS3Storage> SERVICE_MANAGED_S3_FIELD = SdkField
            .<ServiceManagedChannelS3Storage> builder(MarshallingType.SDK_POJO).memberName("serviceManagedS3")
            .getter(getter(ChannelStorage::serviceManagedS3)).setter(setter(Builder::serviceManagedS3))
            .constructor(ServiceManagedChannelS3Storage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceManagedS3").build()).build();

    private static final SdkField<CustomerManagedChannelS3Storage> CUSTOMER_MANAGED_S3_FIELD = SdkField
            .<CustomerManagedChannelS3Storage> builder(MarshallingType.SDK_POJO).memberName("customerManagedS3")
            .getter(getter(ChannelStorage::customerManagedS3)).setter(setter(Builder::customerManagedS3))
            .constructor(CustomerManagedChannelS3Storage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedS3").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_MANAGED_S3_FIELD,
            CUSTOMER_MANAGED_S3_FIELD));

    private static final long serialVersionUID = 1L;

    private final ServiceManagedChannelS3Storage serviceManagedS3;

    private final CustomerManagedChannelS3Storage customerManagedS3;

    private ChannelStorage(BuilderImpl builder) {
        this.serviceManagedS3 = builder.serviceManagedS3;
        this.customerManagedS3 = builder.customerManagedS3;
    }

    /**
     * <p>
     * Use this to store channel data in an S3 bucket managed by AWS IoT Analytics. You cannot change the choice of
     * service-managed or customer-managed S3 storage after the channel is created.
     * </p>
     * 
     * @return Use this to store channel data in an S3 bucket managed by AWS IoT Analytics. You cannot change the choice
     *         of service-managed or customer-managed S3 storage after the channel is created.
     */
    public final ServiceManagedChannelS3Storage serviceManagedS3() {
        return serviceManagedS3;
    }

    /**
     * <p>
     * Use this to store channel data in an S3 bucket that you manage. If customer managed storage is selected, the
     * <code>retentionPeriod</code> parameter is ignored. You cannot change the choice of service-managed or
     * customer-managed S3 storage after the channel is created.
     * </p>
     * 
     * @return Use this to store channel data in an S3 bucket that you manage. If customer managed storage is selected,
     *         the <code>retentionPeriod</code> parameter is ignored. You cannot change the choice of service-managed or
     *         customer-managed S3 storage after the channel is created.
     */
    public final CustomerManagedChannelS3Storage customerManagedS3() {
        return customerManagedS3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceManagedS3());
        hashCode = 31 * hashCode + Objects.hashCode(customerManagedS3());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelStorage)) {
            return false;
        }
        ChannelStorage other = (ChannelStorage) obj;
        return Objects.equals(serviceManagedS3(), other.serviceManagedS3())
                && Objects.equals(customerManagedS3(), other.customerManagedS3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelStorage").add("ServiceManagedS3", serviceManagedS3())
                .add("CustomerManagedS3", customerManagedS3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceManagedS3":
            return Optional.ofNullable(clazz.cast(serviceManagedS3()));
        case "customerManagedS3":
            return Optional.ofNullable(clazz.cast(customerManagedS3()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelStorage, T> g) {
        return obj -> g.apply((ChannelStorage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelStorage> {
        /**
         * <p>
         * Use this to store channel data in an S3 bucket managed by AWS IoT Analytics. You cannot change the choice of
         * service-managed or customer-managed S3 storage after the channel is created.
         * </p>
         * 
         * @param serviceManagedS3
         *        Use this to store channel data in an S3 bucket managed by AWS IoT Analytics. You cannot change the
         *        choice of service-managed or customer-managed S3 storage after the channel is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceManagedS3(ServiceManagedChannelS3Storage serviceManagedS3);

        /**
         * <p>
         * Use this to store channel data in an S3 bucket managed by AWS IoT Analytics. You cannot change the choice of
         * service-managed or customer-managed S3 storage after the channel is created.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceManagedChannelS3Storage.Builder} avoiding
         * the need to create one manually via {@link ServiceManagedChannelS3Storage#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceManagedChannelS3Storage.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceManagedS3(ServiceManagedChannelS3Storage)}.
         * 
         * @param serviceManagedS3
         *        a consumer that will call methods on {@link ServiceManagedChannelS3Storage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceManagedS3(ServiceManagedChannelS3Storage)
         */
        default Builder serviceManagedS3(Consumer<ServiceManagedChannelS3Storage.Builder> serviceManagedS3) {
            return serviceManagedS3(ServiceManagedChannelS3Storage.builder().applyMutation(serviceManagedS3).build());
        }

        /**
         * <p>
         * Use this to store channel data in an S3 bucket that you manage. If customer managed storage is selected, the
         * <code>retentionPeriod</code> parameter is ignored. You cannot change the choice of service-managed or
         * customer-managed S3 storage after the channel is created.
         * </p>
         * 
         * @param customerManagedS3
         *        Use this to store channel data in an S3 bucket that you manage. If customer managed storage is
         *        selected, the <code>retentionPeriod</code> parameter is ignored. You cannot change the choice of
         *        service-managed or customer-managed S3 storage after the channel is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedS3(CustomerManagedChannelS3Storage customerManagedS3);

        /**
         * <p>
         * Use this to store channel data in an S3 bucket that you manage. If customer managed storage is selected, the
         * <code>retentionPeriod</code> parameter is ignored. You cannot change the choice of service-managed or
         * customer-managed S3 storage after the channel is created.
         * </p>
         * This is a convenience that creates an instance of the {@link CustomerManagedChannelS3Storage.Builder}
         * avoiding the need to create one manually via {@link CustomerManagedChannelS3Storage#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomerManagedChannelS3Storage.Builder#build()} is called
         * immediately and its result is passed to {@link #customerManagedS3(CustomerManagedChannelS3Storage)}.
         * 
         * @param customerManagedS3
         *        a consumer that will call methods on {@link CustomerManagedChannelS3Storage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerManagedS3(CustomerManagedChannelS3Storage)
         */
        default Builder customerManagedS3(Consumer<CustomerManagedChannelS3Storage.Builder> customerManagedS3) {
            return customerManagedS3(CustomerManagedChannelS3Storage.builder().applyMutation(customerManagedS3).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ServiceManagedChannelS3Storage serviceManagedS3;

        private CustomerManagedChannelS3Storage customerManagedS3;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelStorage model) {
            serviceManagedS3(model.serviceManagedS3);
            customerManagedS3(model.customerManagedS3);
        }

        public final ServiceManagedChannelS3Storage.Builder getServiceManagedS3() {
            return serviceManagedS3 != null ? serviceManagedS3.toBuilder() : null;
        }

        @Override
        public final Builder serviceManagedS3(ServiceManagedChannelS3Storage serviceManagedS3) {
            this.serviceManagedS3 = serviceManagedS3;
            return this;
        }

        public final void setServiceManagedS3(ServiceManagedChannelS3Storage.BuilderImpl serviceManagedS3) {
            this.serviceManagedS3 = serviceManagedS3 != null ? serviceManagedS3.build() : null;
        }

        public final CustomerManagedChannelS3Storage.Builder getCustomerManagedS3() {
            return customerManagedS3 != null ? customerManagedS3.toBuilder() : null;
        }

        @Override
        public final Builder customerManagedS3(CustomerManagedChannelS3Storage customerManagedS3) {
            this.customerManagedS3 = customerManagedS3;
            return this;
        }

        public final void setCustomerManagedS3(CustomerManagedChannelS3Storage.BuilderImpl customerManagedS3) {
            this.customerManagedS3 = customerManagedS3 != null ? customerManagedS3.build() : null;
        }

        @Override
        public ChannelStorage build() {
            return new ChannelStorage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
