/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The state of the data set contents and the reason they are in this state.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetContentStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetContentStatus.Builder, DatasetContentStatus> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(DatasetContentStatus::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(DatasetContentStatus::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String state;

    private final String reason;

    private DatasetContentStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The state of the data set contents. Can be one of READY, CREATING, SUCCEEDED, or FAILED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DatasetContentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the data set contents. Can be one of READY, CREATING, SUCCEEDED, or FAILED.
     * @see DatasetContentState
     */
    public final DatasetContentState state() {
        return DatasetContentState.fromValue(state);
    }

    /**
     * <p>
     * The state of the data set contents. Can be one of READY, CREATING, SUCCEEDED, or FAILED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DatasetContentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the data set contents. Can be one of READY, CREATING, SUCCEEDED, or FAILED.
     * @see DatasetContentState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The reason the data set contents are in this state.
     * </p>
     * 
     * @return The reason the data set contents are in this state.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetContentStatus)) {
            return false;
        }
        DatasetContentStatus other = (DatasetContentStatus) obj;
        return Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetContentStatus").add("State", stateAsString()).add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetContentStatus, T> g) {
        return obj -> g.apply((DatasetContentStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetContentStatus> {
        /**
         * <p>
         * The state of the data set contents. Can be one of READY, CREATING, SUCCEEDED, or FAILED.
         * </p>
         * 
         * @param state
         *        The state of the data set contents. Can be one of READY, CREATING, SUCCEEDED, or FAILED.
         * @see DatasetContentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetContentState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the data set contents. Can be one of READY, CREATING, SUCCEEDED, or FAILED.
         * </p>
         * 
         * @param state
         *        The state of the data set contents. Can be one of READY, CREATING, SUCCEEDED, or FAILED.
         * @see DatasetContentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetContentState
         */
        Builder state(DatasetContentState state);

        /**
         * <p>
         * The reason the data set contents are in this state.
         * </p>
         * 
         * @param reason
         *        The reason the data set contents are in this state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetContentStatus model) {
            state(model.state);
            reason(model.reason);
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DatasetContentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public DatasetContentStatus build() {
            return new DatasetContentStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
