/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The dataset whose latest contents are used as input to the notebook or application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetContentVersionValue implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetContentVersionValue.Builder, DatasetContentVersionValue> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetName").getter(getter(DatasetContentVersionValue::datasetName))
            .setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String datasetName;

    private DatasetContentVersionValue(BuilderImpl builder) {
        this.datasetName = builder.datasetName;
    }

    /**
     * <p>
     * The name of the dataset whose latest contents are used as input to the notebook or application.
     * </p>
     * 
     * @return The name of the dataset whose latest contents are used as input to the notebook or application.
     */
    public final String datasetName() {
        return datasetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetContentVersionValue)) {
            return false;
        }
        DatasetContentVersionValue other = (DatasetContentVersionValue) obj;
        return Objects.equals(datasetName(), other.datasetName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetContentVersionValue").add("DatasetName", datasetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetContentVersionValue, T> g) {
        return obj -> g.apply((DatasetContentVersionValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetContentVersionValue> {
        /**
         * <p>
         * The name of the dataset whose latest contents are used as input to the notebook or application.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset whose latest contents are used as input to the notebook or application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);
    }

    static final class BuilderImpl implements Builder {
        private String datasetName;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetContentVersionValue model) {
            datasetName(model.datasetName);
        }

        public final String getDatasetName() {
            return datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public DatasetContentVersionValue build() {
            return new DatasetContentVersionValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
