/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutLoggingOptionsRequest extends IoTAnalyticsRequest implements
        ToCopyableBuilder<PutLoggingOptionsRequest.Builder, PutLoggingOptionsRequest> {
    private static final SdkField<LoggingOptions> LOGGING_OPTIONS_FIELD = SdkField
            .<LoggingOptions> builder(MarshallingType.SDK_POJO).memberName("loggingOptions")
            .getter(getter(PutLoggingOptionsRequest::loggingOptions)).setter(setter(Builder::loggingOptions))
            .constructor(LoggingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGGING_OPTIONS_FIELD));

    private final LoggingOptions loggingOptions;

    private PutLoggingOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.loggingOptions = builder.loggingOptions;
    }

    /**
     * <p>
     * The new values of the AWS IoT Analytics logging options.
     * </p>
     * 
     * @return The new values of the AWS IoT Analytics logging options.
     */
    public final LoggingOptions loggingOptions() {
        return loggingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loggingOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLoggingOptionsRequest)) {
            return false;
        }
        PutLoggingOptionsRequest other = (PutLoggingOptionsRequest) obj;
        return Objects.equals(loggingOptions(), other.loggingOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutLoggingOptionsRequest").add("LoggingOptions", loggingOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "loggingOptions":
            return Optional.ofNullable(clazz.cast(loggingOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutLoggingOptionsRequest, T> g) {
        return obj -> g.apply((PutLoggingOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTAnalyticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutLoggingOptionsRequest> {
        /**
         * <p>
         * The new values of the AWS IoT Analytics logging options.
         * </p>
         * 
         * @param loggingOptions
         *        The new values of the AWS IoT Analytics logging options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingOptions(LoggingOptions loggingOptions);

        /**
         * <p>
         * The new values of the AWS IoT Analytics logging options.
         * </p>
         * This is a convenience that creates an instance of the {@link LoggingOptions.Builder} avoiding the need to
         * create one manually via {@link LoggingOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoggingOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #loggingOptions(LoggingOptions)}.
         * 
         * @param loggingOptions
         *        a consumer that will call methods on {@link LoggingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingOptions(LoggingOptions)
         */
        default Builder loggingOptions(Consumer<LoggingOptions.Builder> loggingOptions) {
            return loggingOptions(LoggingOptions.builder().applyMutation(loggingOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTAnalyticsRequest.BuilderImpl implements Builder {
        private LoggingOptions loggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(PutLoggingOptionsRequest model) {
            super(model);
            loggingOptions(model.loggingOptions);
        }

        public final LoggingOptions.Builder getLoggingOptions() {
            return loggingOptions != null ? loggingOptions.toBuilder() : null;
        }

        @Override
        public final Builder loggingOptions(LoggingOptions loggingOptions) {
            this.loggingOptions = loggingOptions;
            return this;
        }

        public final void setLoggingOptions(LoggingOptions.BuilderImpl loggingOptions) {
            this.loggingOptions = loggingOptions != null ? loggingOptions.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutLoggingOptionsRequest build() {
            return new PutLoggingOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
