/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelPipelineReprocessingRequest extends IoTAnalyticsRequest implements
        ToCopyableBuilder<CancelPipelineReprocessingRequest.Builder, CancelPipelineReprocessingRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineName").getter(getter(CancelPipelineReprocessingRequest::pipelineName))
            .setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("pipelineName").build()).build();

    private static final SdkField<String> REPROCESSING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reprocessingId").getter(getter(CancelPipelineReprocessingRequest::reprocessingId))
            .setter(setter(Builder::reprocessingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("reprocessingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD,
            REPROCESSING_ID_FIELD));

    private final String pipelineName;

    private final String reprocessingId;

    private CancelPipelineReprocessingRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.reprocessingId = builder.reprocessingId;
    }

    /**
     * <p>
     * The name of pipeline for which data reprocessing is canceled.
     * </p>
     * 
     * @return The name of pipeline for which data reprocessing is canceled.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * <p>
     * The ID of the reprocessing task (returned by <code>StartPipelineReprocessing</code>).
     * </p>
     * 
     * @return The ID of the reprocessing task (returned by <code>StartPipelineReprocessing</code>).
     */
    public final String reprocessingId() {
        return reprocessingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(reprocessingId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelPipelineReprocessingRequest)) {
            return false;
        }
        CancelPipelineReprocessingRequest other = (CancelPipelineReprocessingRequest) obj;
        return Objects.equals(pipelineName(), other.pipelineName()) && Objects.equals(reprocessingId(), other.reprocessingId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelPipelineReprocessingRequest").add("PipelineName", pipelineName())
                .add("ReprocessingId", reprocessingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "reprocessingId":
            return Optional.ofNullable(clazz.cast(reprocessingId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelPipelineReprocessingRequest, T> g) {
        return obj -> g.apply((CancelPipelineReprocessingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTAnalyticsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CancelPipelineReprocessingRequest> {
        /**
         * <p>
         * The name of pipeline for which data reprocessing is canceled.
         * </p>
         * 
         * @param pipelineName
         *        The name of pipeline for which data reprocessing is canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * The ID of the reprocessing task (returned by <code>StartPipelineReprocessing</code>).
         * </p>
         * 
         * @param reprocessingId
         *        The ID of the reprocessing task (returned by <code>StartPipelineReprocessing</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reprocessingId(String reprocessingId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTAnalyticsRequest.BuilderImpl implements Builder {
        private String pipelineName;

        private String reprocessingId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelPipelineReprocessingRequest model) {
            super(model);
            pipelineName(model.pipelineName);
            reprocessingId(model.reprocessingId);
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        @Transient
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final String getReprocessingId() {
            return reprocessingId;
        }

        public final void setReprocessingId(String reprocessingId) {
            this.reprocessingId = reprocessingId;
        }

        @Override
        @Transient
        public final Builder reprocessingId(String reprocessingId) {
            this.reprocessingId = reprocessingId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelPipelineReprocessingRequest build() {
            return new CancelPipelineReprocessingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
