/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single dimension to partition a data store. The dimension must be an <code>AttributePartition</code> or a
 * <code>TimestampPartition</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatastorePartition implements SdkPojo, Serializable,
        ToCopyableBuilder<DatastorePartition.Builder, DatastorePartition> {
    private static final SdkField<Partition> ATTRIBUTE_PARTITION_FIELD = SdkField.<Partition> builder(MarshallingType.SDK_POJO)
            .memberName("attributePartition").getter(getter(DatastorePartition::attributePartition))
            .setter(setter(Builder::attributePartition)).constructor(Partition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributePartition").build())
            .build();

    private static final SdkField<TimestampPartition> TIMESTAMP_PARTITION_FIELD = SdkField
            .<TimestampPartition> builder(MarshallingType.SDK_POJO).memberName("timestampPartition")
            .getter(getter(DatastorePartition::timestampPartition)).setter(setter(Builder::timestampPartition))
            .constructor(TimestampPartition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestampPartition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_PARTITION_FIELD,
            TIMESTAMP_PARTITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Partition attributePartition;

    private final TimestampPartition timestampPartition;

    private DatastorePartition(BuilderImpl builder) {
        this.attributePartition = builder.attributePartition;
        this.timestampPartition = builder.timestampPartition;
    }

    /**
     * <p>
     * A partition dimension defined by an <code>attributeName</code>.
     * </p>
     * 
     * @return A partition dimension defined by an <code>attributeName</code>.
     */
    public final Partition attributePartition() {
        return attributePartition;
    }

    /**
     * <p>
     * A partition dimension defined by a timestamp attribute.
     * </p>
     * 
     * @return A partition dimension defined by a timestamp attribute.
     */
    public final TimestampPartition timestampPartition() {
        return timestampPartition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributePartition());
        hashCode = 31 * hashCode + Objects.hashCode(timestampPartition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastorePartition)) {
            return false;
        }
        DatastorePartition other = (DatastorePartition) obj;
        return Objects.equals(attributePartition(), other.attributePartition())
                && Objects.equals(timestampPartition(), other.timestampPartition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatastorePartition").add("AttributePartition", attributePartition())
                .add("TimestampPartition", timestampPartition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributePartition":
            return Optional.ofNullable(clazz.cast(attributePartition()));
        case "timestampPartition":
            return Optional.ofNullable(clazz.cast(timestampPartition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatastorePartition, T> g) {
        return obj -> g.apply((DatastorePartition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatastorePartition> {
        /**
         * <p>
         * A partition dimension defined by an <code>attributeName</code>.
         * </p>
         * 
         * @param attributePartition
         *        A partition dimension defined by an <code>attributeName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributePartition(Partition attributePartition);

        /**
         * <p>
         * A partition dimension defined by an <code>attributeName</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link Partition.Builder} avoiding the need to create
         * one manually via {@link Partition#builder()}.
         *
         * When the {@link Consumer} completes, {@link Partition.Builder#build()} is called immediately and its result
         * is passed to {@link #attributePartition(Partition)}.
         * 
         * @param attributePartition
         *        a consumer that will call methods on {@link Partition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributePartition(Partition)
         */
        default Builder attributePartition(Consumer<Partition.Builder> attributePartition) {
            return attributePartition(Partition.builder().applyMutation(attributePartition).build());
        }

        /**
         * <p>
         * A partition dimension defined by a timestamp attribute.
         * </p>
         * 
         * @param timestampPartition
         *        A partition dimension defined by a timestamp attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampPartition(TimestampPartition timestampPartition);

        /**
         * <p>
         * A partition dimension defined by a timestamp attribute.
         * </p>
         * This is a convenience that creates an instance of the {@link TimestampPartition.Builder} avoiding the need to
         * create one manually via {@link TimestampPartition#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimestampPartition.Builder#build()} is called immediately and its
         * result is passed to {@link #timestampPartition(TimestampPartition)}.
         * 
         * @param timestampPartition
         *        a consumer that will call methods on {@link TimestampPartition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestampPartition(TimestampPartition)
         */
        default Builder timestampPartition(Consumer<TimestampPartition.Builder> timestampPartition) {
            return timestampPartition(TimestampPartition.builder().applyMutation(timestampPartition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Partition attributePartition;

        private TimestampPartition timestampPartition;

        private BuilderImpl() {
        }

        private BuilderImpl(DatastorePartition model) {
            attributePartition(model.attributePartition);
            timestampPartition(model.timestampPartition);
        }

        public final Partition.Builder getAttributePartition() {
            return attributePartition != null ? attributePartition.toBuilder() : null;
        }

        public final void setAttributePartition(Partition.BuilderImpl attributePartition) {
            this.attributePartition = attributePartition != null ? attributePartition.build() : null;
        }

        @Override
        @Transient
        public final Builder attributePartition(Partition attributePartition) {
            this.attributePartition = attributePartition;
            return this;
        }

        public final TimestampPartition.Builder getTimestampPartition() {
            return timestampPartition != null ? timestampPartition.toBuilder() : null;
        }

        public final void setTimestampPartition(TimestampPartition.BuilderImpl timestampPartition) {
            this.timestampPartition = timestampPartition != null ? timestampPartition.build() : null;
        }

        @Override
        @Transient
        public final Builder timestampPartition(TimestampPartition timestampPartition) {
            this.timestampPartition = timestampPartition;
            return this;
        }

        @Override
        public DatastorePartition build() {
            return new DatastorePartition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
