/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDatastoresResponse extends IoTAnalyticsResponse implements
        ToCopyableBuilder<ListDatastoresResponse.Builder, ListDatastoresResponse> {
    private static final SdkField<List<DatastoreSummary>> DATASTORE_SUMMARIES_FIELD = SdkField
            .<List<DatastoreSummary>> builder(MarshallingType.LIST)
            .memberName("datastoreSummaries")
            .getter(getter(ListDatastoresResponse::datastoreSummaries))
            .setter(setter(Builder::datastoreSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatastoreSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatastoreSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDatastoresResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DatastoreSummary> datastoreSummaries;

    private final String nextToken;

    private ListDatastoresResponse(BuilderImpl builder) {
        super(builder);
        this.datastoreSummaries = builder.datastoreSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DatastoreSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDatastoreSummaries() {
        return datastoreSummaries != null && !(datastoreSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DatastoreSummary</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDatastoreSummaries} method.
     * </p>
     * 
     * @return A list of <code>DatastoreSummary</code> objects.
     */
    public final List<DatastoreSummary> datastoreSummaries() {
        return datastoreSummaries;
    }

    /**
     * <p>
     * The token to retrieve the next set of results, or <code>null</code> if there are no more results.
     * </p>
     * 
     * @return The token to retrieve the next set of results, or <code>null</code> if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDatastoreSummaries() ? datastoreSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatastoresResponse)) {
            return false;
        }
        ListDatastoresResponse other = (ListDatastoresResponse) obj;
        return hasDatastoreSummaries() == other.hasDatastoreSummaries()
                && Objects.equals(datastoreSummaries(), other.datastoreSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDatastoresResponse")
                .add("DatastoreSummaries", hasDatastoreSummaries() ? datastoreSummaries() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datastoreSummaries":
            return Optional.ofNullable(clazz.cast(datastoreSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDatastoresResponse, T> g) {
        return obj -> g.apply((ListDatastoresResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTAnalyticsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDatastoresResponse> {
        /**
         * <p>
         * A list of <code>DatastoreSummary</code> objects.
         * </p>
         * 
         * @param datastoreSummaries
         *        A list of <code>DatastoreSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreSummaries(Collection<DatastoreSummary> datastoreSummaries);

        /**
         * <p>
         * A list of <code>DatastoreSummary</code> objects.
         * </p>
         * 
         * @param datastoreSummaries
         *        A list of <code>DatastoreSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreSummaries(DatastoreSummary... datastoreSummaries);

        /**
         * <p>
         * A list of <code>DatastoreSummary</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DatastoreSummary>.Builder} avoiding the
         * need to create one manually via {@link List<DatastoreSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DatastoreSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #datastoreSummaries(List<DatastoreSummary>)}.
         * 
         * @param datastoreSummaries
         *        a consumer that will call methods on {@link List<DatastoreSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datastoreSummaries(List<DatastoreSummary>)
         */
        Builder datastoreSummaries(Consumer<DatastoreSummary.Builder>... datastoreSummaries);

        /**
         * <p>
         * The token to retrieve the next set of results, or <code>null</code> if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results, or <code>null</code> if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTAnalyticsResponse.BuilderImpl implements Builder {
        private List<DatastoreSummary> datastoreSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatastoresResponse model) {
            super(model);
            datastoreSummaries(model.datastoreSummaries);
            nextToken(model.nextToken);
        }

        public final List<DatastoreSummary.Builder> getDatastoreSummaries() {
            List<DatastoreSummary.Builder> result = DatastoreSummariesCopier.copyToBuilder(this.datastoreSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatastoreSummaries(Collection<DatastoreSummary.BuilderImpl> datastoreSummaries) {
            this.datastoreSummaries = DatastoreSummariesCopier.copyFromBuilder(datastoreSummaries);
        }

        @Override
        @Transient
        public final Builder datastoreSummaries(Collection<DatastoreSummary> datastoreSummaries) {
            this.datastoreSummaries = DatastoreSummariesCopier.copy(datastoreSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder datastoreSummaries(DatastoreSummary... datastoreSummaries) {
            datastoreSummaries(Arrays.asList(datastoreSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder datastoreSummaries(Consumer<DatastoreSummary.Builder>... datastoreSummaries) {
            datastoreSummaries(Stream.of(datastoreSummaries).map(c -> DatastoreSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDatastoresResponse build() {
            return new ListDatastoresResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
