/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDatasetRequest extends IoTAnalyticsRequest implements
        ToCopyableBuilder<UpdateDatasetRequest.Builder, UpdateDatasetRequest> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetName").getter(getter(UpdateDatasetRequest::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetName").build()).build();

    private static final SdkField<List<DatasetAction>> ACTIONS_FIELD = SdkField
            .<List<DatasetAction>> builder(MarshallingType.LIST)
            .memberName("actions")
            .getter(getter(UpdateDatasetRequest::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatasetAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DatasetTrigger>> TRIGGERS_FIELD = SdkField
            .<List<DatasetTrigger>> builder(MarshallingType.LIST)
            .memberName("triggers")
            .getter(getter(UpdateDatasetRequest::triggers))
            .setter(setter(Builder::triggers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatasetTrigger> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetTrigger::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DatasetContentDeliveryRule>> CONTENT_DELIVERY_RULES_FIELD = SdkField
            .<List<DatasetContentDeliveryRule>> builder(MarshallingType.LIST)
            .memberName("contentDeliveryRules")
            .getter(getter(UpdateDatasetRequest::contentDeliveryRules))
            .setter(setter(Builder::contentDeliveryRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentDeliveryRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatasetContentDeliveryRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetContentDeliveryRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField
            .<RetentionPeriod> builder(MarshallingType.SDK_POJO).memberName("retentionPeriod")
            .getter(getter(UpdateDatasetRequest::retentionPeriod)).setter(setter(Builder::retentionPeriod))
            .constructor(RetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()).build();

    private static final SdkField<VersioningConfiguration> VERSIONING_CONFIGURATION_FIELD = SdkField
            .<VersioningConfiguration> builder(MarshallingType.SDK_POJO).memberName("versioningConfiguration")
            .getter(getter(UpdateDatasetRequest::versioningConfiguration)).setter(setter(Builder::versioningConfiguration))
            .constructor(VersioningConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versioningConfiguration").build())
            .build();

    private static final SdkField<List<LateDataRule>> LATE_DATA_RULES_FIELD = SdkField
            .<List<LateDataRule>> builder(MarshallingType.LIST)
            .memberName("lateDataRules")
            .getter(getter(UpdateDatasetRequest::lateDataRules))
            .setter(setter(Builder::lateDataRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lateDataRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LateDataRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(LateDataRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD,
            ACTIONS_FIELD, TRIGGERS_FIELD, CONTENT_DELIVERY_RULES_FIELD, RETENTION_PERIOD_FIELD, VERSIONING_CONFIGURATION_FIELD,
            LATE_DATA_RULES_FIELD));

    private final String datasetName;

    private final List<DatasetAction> actions;

    private final List<DatasetTrigger> triggers;

    private final List<DatasetContentDeliveryRule> contentDeliveryRules;

    private final RetentionPeriod retentionPeriod;

    private final VersioningConfiguration versioningConfiguration;

    private final List<LateDataRule> lateDataRules;

    private UpdateDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.datasetName = builder.datasetName;
        this.actions = builder.actions;
        this.triggers = builder.triggers;
        this.contentDeliveryRules = builder.contentDeliveryRules;
        this.retentionPeriod = builder.retentionPeriod;
        this.versioningConfiguration = builder.versioningConfiguration;
        this.lateDataRules = builder.lateDataRules;
    }

    /**
     * <p>
     * The name of the dataset to update.
     * </p>
     * 
     * @return The name of the dataset to update.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DatasetAction</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return A list of <code>DatasetAction</code> objects.
     */
    public final List<DatasetAction> actions() {
        return actions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Triggers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTriggers() {
        return triggers != null && !(triggers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DatasetTrigger</code> objects. The list can be empty or can contain up to five
     * <code>DatasetTrigger</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTriggers} method.
     * </p>
     * 
     * @return A list of <code>DatasetTrigger</code> objects. The list can be empty or can contain up to five
     *         <code>DatasetTrigger</code> objects.
     */
    public final List<DatasetTrigger> triggers() {
        return triggers;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContentDeliveryRules property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContentDeliveryRules() {
        return contentDeliveryRules != null && !(contentDeliveryRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * When dataset contents are created, they are delivered to destinations specified here.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContentDeliveryRules} method.
     * </p>
     * 
     * @return When dataset contents are created, they are delivered to destinations specified here.
     */
    public final List<DatasetContentDeliveryRule> contentDeliveryRules() {
        return contentDeliveryRules;
    }

    /**
     * <p>
     * How long, in days, dataset contents are kept for the dataset.
     * </p>
     * 
     * @return How long, in days, dataset contents are kept for the dataset.
     */
    public final RetentionPeriod retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest
     * version plus the latest succeeded version (if they are different) are kept for the time period specified by the
     * <code>retentionPeriod</code> parameter. For more information, see <a href=
     * "https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions"
     * >Keeping Multiple Versions of IoT Analytics datasets</a> in the <i>IoT Analytics User Guide</i>.
     * </p>
     * 
     * @return Optional. How many versions of dataset contents are kept. If not specified or set to null, only the
     *         latest version plus the latest succeeded version (if they are different) are kept for the time period
     *         specified by the <code>retentionPeriod</code> parameter. For more information, see <a href=
     *         "https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions"
     *         >Keeping Multiple Versions of IoT Analytics datasets</a> in the <i>IoT Analytics User Guide</i>.
     */
    public final VersioningConfiguration versioningConfiguration() {
        return versioningConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the LateDataRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLateDataRules() {
        return lateDataRules != null && !(lateDataRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of data rules that send notifications to CloudWatch, when data arrives late. To specify
     * <code>lateDataRules</code>, the dataset must use a <a
     * href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLateDataRules} method.
     * </p>
     * 
     * @return A list of data rules that send notifications to CloudWatch, when data arrives late. To specify
     *         <code>lateDataRules</code>, the dataset must use a <a
     *         href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a>
     *         filter.
     */
    public final List<LateDataRule> lateDataRules() {
        return lateDataRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTriggers() ? triggers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasContentDeliveryRules() ? contentDeliveryRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(versioningConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasLateDataRules() ? lateDataRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatasetRequest)) {
            return false;
        }
        UpdateDatasetRequest other = (UpdateDatasetRequest) obj;
        return Objects.equals(datasetName(), other.datasetName()) && hasActions() == other.hasActions()
                && Objects.equals(actions(), other.actions()) && hasTriggers() == other.hasTriggers()
                && Objects.equals(triggers(), other.triggers()) && hasContentDeliveryRules() == other.hasContentDeliveryRules()
                && Objects.equals(contentDeliveryRules(), other.contentDeliveryRules())
                && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(versioningConfiguration(), other.versioningConfiguration())
                && hasLateDataRules() == other.hasLateDataRules() && Objects.equals(lateDataRules(), other.lateDataRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDatasetRequest").add("DatasetName", datasetName())
                .add("Actions", hasActions() ? actions() : null).add("Triggers", hasTriggers() ? triggers() : null)
                .add("ContentDeliveryRules", hasContentDeliveryRules() ? contentDeliveryRules() : null)
                .add("RetentionPeriod", retentionPeriod()).add("VersioningConfiguration", versioningConfiguration())
                .add("LateDataRules", hasLateDataRules() ? lateDataRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "triggers":
            return Optional.ofNullable(clazz.cast(triggers()));
        case "contentDeliveryRules":
            return Optional.ofNullable(clazz.cast(contentDeliveryRules()));
        case "retentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "versioningConfiguration":
            return Optional.ofNullable(clazz.cast(versioningConfiguration()));
        case "lateDataRules":
            return Optional.ofNullable(clazz.cast(lateDataRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDatasetRequest, T> g) {
        return obj -> g.apply((UpdateDatasetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTAnalyticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDatasetRequest> {
        /**
         * <p>
         * The name of the dataset to update.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * A list of <code>DatasetAction</code> objects.
         * </p>
         * 
         * @param actions
         *        A list of <code>DatasetAction</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<DatasetAction> actions);

        /**
         * <p>
         * A list of <code>DatasetAction</code> objects.
         * </p>
         * 
         * @param actions
         *        A list of <code>DatasetAction</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(DatasetAction... actions);

        /**
         * <p>
         * A list of <code>DatasetAction</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DatasetAction>.Builder} avoiding the need
         * to create one manually via {@link List<DatasetAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DatasetAction>.Builder#build()} is called immediately and
         * its result is passed to {@link #actions(List<DatasetAction>)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link List<DatasetAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(List<DatasetAction>)
         */
        Builder actions(Consumer<DatasetAction.Builder>... actions);

        /**
         * <p>
         * A list of <code>DatasetTrigger</code> objects. The list can be empty or can contain up to five
         * <code>DatasetTrigger</code> objects.
         * </p>
         * 
         * @param triggers
         *        A list of <code>DatasetTrigger</code> objects. The list can be empty or can contain up to five
         *        <code>DatasetTrigger</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(Collection<DatasetTrigger> triggers);

        /**
         * <p>
         * A list of <code>DatasetTrigger</code> objects. The list can be empty or can contain up to five
         * <code>DatasetTrigger</code> objects.
         * </p>
         * 
         * @param triggers
         *        A list of <code>DatasetTrigger</code> objects. The list can be empty or can contain up to five
         *        <code>DatasetTrigger</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(DatasetTrigger... triggers);

        /**
         * <p>
         * A list of <code>DatasetTrigger</code> objects. The list can be empty or can contain up to five
         * <code>DatasetTrigger</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DatasetTrigger>.Builder} avoiding the need
         * to create one manually via {@link List<DatasetTrigger>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DatasetTrigger>.Builder#build()} is called immediately and
         * its result is passed to {@link #triggers(List<DatasetTrigger>)}.
         * 
         * @param triggers
         *        a consumer that will call methods on {@link List<DatasetTrigger>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggers(List<DatasetTrigger>)
         */
        Builder triggers(Consumer<DatasetTrigger.Builder>... triggers);

        /**
         * <p>
         * When dataset contents are created, they are delivered to destinations specified here.
         * </p>
         * 
         * @param contentDeliveryRules
         *        When dataset contents are created, they are delivered to destinations specified here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentDeliveryRules(Collection<DatasetContentDeliveryRule> contentDeliveryRules);

        /**
         * <p>
         * When dataset contents are created, they are delivered to destinations specified here.
         * </p>
         * 
         * @param contentDeliveryRules
         *        When dataset contents are created, they are delivered to destinations specified here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentDeliveryRules(DatasetContentDeliveryRule... contentDeliveryRules);

        /**
         * <p>
         * When dataset contents are created, they are delivered to destinations specified here.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DatasetContentDeliveryRule>.Builder}
         * avoiding the need to create one manually via {@link List<DatasetContentDeliveryRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DatasetContentDeliveryRule>.Builder#build()} is called
         * immediately and its result is passed to {@link #contentDeliveryRules(List<DatasetContentDeliveryRule>)}.
         * 
         * @param contentDeliveryRules
         *        a consumer that will call methods on {@link List<DatasetContentDeliveryRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentDeliveryRules(List<DatasetContentDeliveryRule>)
         */
        Builder contentDeliveryRules(Consumer<DatasetContentDeliveryRule.Builder>... contentDeliveryRules);

        /**
         * <p>
         * How long, in days, dataset contents are kept for the dataset.
         * </p>
         * 
         * @param retentionPeriod
         *        How long, in days, dataset contents are kept for the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(RetentionPeriod retentionPeriod);

        /**
         * <p>
         * How long, in days, dataset contents are kept for the dataset.
         * </p>
         * This is a convenience that creates an instance of the {@link RetentionPeriod.Builder} avoiding the need to
         * create one manually via {@link RetentionPeriod#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetentionPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #retentionPeriod(RetentionPeriod)}.
         * 
         * @param retentionPeriod
         *        a consumer that will call methods on {@link RetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionPeriod(RetentionPeriod)
         */
        default Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return retentionPeriod(RetentionPeriod.builder().applyMutation(retentionPeriod).build());
        }

        /**
         * <p>
         * Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest
         * version plus the latest succeeded version (if they are different) are kept for the time period specified by
         * the <code>retentionPeriod</code> parameter. For more information, see <a href=
         * "https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions"
         * >Keeping Multiple Versions of IoT Analytics datasets</a> in the <i>IoT Analytics User Guide</i>.
         * </p>
         * 
         * @param versioningConfiguration
         *        Optional. How many versions of dataset contents are kept. If not specified or set to null, only the
         *        latest version plus the latest succeeded version (if they are different) are kept for the time period
         *        specified by the <code>retentionPeriod</code> parameter. For more information, see <a href=
         *        "https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions"
         *        >Keeping Multiple Versions of IoT Analytics datasets</a> in the <i>IoT Analytics User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versioningConfiguration(VersioningConfiguration versioningConfiguration);

        /**
         * <p>
         * Optional. How many versions of dataset contents are kept. If not specified or set to null, only the latest
         * version plus the latest succeeded version (if they are different) are kept for the time period specified by
         * the <code>retentionPeriod</code> parameter. For more information, see <a href=
         * "https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions"
         * >Keeping Multiple Versions of IoT Analytics datasets</a> in the <i>IoT Analytics User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link VersioningConfiguration.Builder} avoiding the
         * need to create one manually via {@link VersioningConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link VersioningConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #versioningConfiguration(VersioningConfiguration)}.
         * 
         * @param versioningConfiguration
         *        a consumer that will call methods on {@link VersioningConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #versioningConfiguration(VersioningConfiguration)
         */
        default Builder versioningConfiguration(Consumer<VersioningConfiguration.Builder> versioningConfiguration) {
            return versioningConfiguration(VersioningConfiguration.builder().applyMutation(versioningConfiguration).build());
        }

        /**
         * <p>
         * A list of data rules that send notifications to CloudWatch, when data arrives late. To specify
         * <code>lateDataRules</code>, the dataset must use a <a
         * href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.
         * </p>
         * 
         * @param lateDataRules
         *        A list of data rules that send notifications to CloudWatch, when data arrives late. To specify
         *        <code>lateDataRules</code>, the dataset must use a <a
         *        href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a>
         *        filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lateDataRules(Collection<LateDataRule> lateDataRules);

        /**
         * <p>
         * A list of data rules that send notifications to CloudWatch, when data arrives late. To specify
         * <code>lateDataRules</code>, the dataset must use a <a
         * href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.
         * </p>
         * 
         * @param lateDataRules
         *        A list of data rules that send notifications to CloudWatch, when data arrives late. To specify
         *        <code>lateDataRules</code>, the dataset must use a <a
         *        href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a>
         *        filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lateDataRules(LateDataRule... lateDataRules);

        /**
         * <p>
         * A list of data rules that send notifications to CloudWatch, when data arrives late. To specify
         * <code>lateDataRules</code>, the dataset must use a <a
         * href="https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_DeltaTime.html">DeltaTimer</a> filter.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LateDataRule>.Builder} avoiding the need to
         * create one manually via {@link List<LateDataRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LateDataRule>.Builder#build()} is called immediately and its
         * result is passed to {@link #lateDataRules(List<LateDataRule>)}.
         * 
         * @param lateDataRules
         *        a consumer that will call methods on {@link List<LateDataRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lateDataRules(List<LateDataRule>)
         */
        Builder lateDataRules(Consumer<LateDataRule.Builder>... lateDataRules);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTAnalyticsRequest.BuilderImpl implements Builder {
        private String datasetName;

        private List<DatasetAction> actions = DefaultSdkAutoConstructList.getInstance();

        private List<DatasetTrigger> triggers = DefaultSdkAutoConstructList.getInstance();

        private List<DatasetContentDeliveryRule> contentDeliveryRules = DefaultSdkAutoConstructList.getInstance();

        private RetentionPeriod retentionPeriod;

        private VersioningConfiguration versioningConfiguration;

        private List<LateDataRule> lateDataRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDatasetRequest model) {
            super(model);
            datasetName(model.datasetName);
            actions(model.actions);
            triggers(model.triggers);
            contentDeliveryRules(model.contentDeliveryRules);
            retentionPeriod(model.retentionPeriod);
            versioningConfiguration(model.versioningConfiguration);
            lateDataRules(model.lateDataRules);
        }

        public final String getDatasetName() {
            return datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        @Transient
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final List<DatasetAction.Builder> getActions() {
            List<DatasetAction.Builder> result = DatasetActionsCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<DatasetAction.BuilderImpl> actions) {
            this.actions = DatasetActionsCopier.copyFromBuilder(actions);
        }

        @Override
        @Transient
        public final Builder actions(Collection<DatasetAction> actions) {
            this.actions = DatasetActionsCopier.copy(actions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actions(DatasetAction... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actions(Consumer<DatasetAction.Builder>... actions) {
            actions(Stream.of(actions).map(c -> DatasetAction.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DatasetTrigger.Builder> getTriggers() {
            List<DatasetTrigger.Builder> result = DatasetTriggersCopier.copyToBuilder(this.triggers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggers(Collection<DatasetTrigger.BuilderImpl> triggers) {
            this.triggers = DatasetTriggersCopier.copyFromBuilder(triggers);
        }

        @Override
        @Transient
        public final Builder triggers(Collection<DatasetTrigger> triggers) {
            this.triggers = DatasetTriggersCopier.copy(triggers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder triggers(DatasetTrigger... triggers) {
            triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder triggers(Consumer<DatasetTrigger.Builder>... triggers) {
            triggers(Stream.of(triggers).map(c -> DatasetTrigger.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DatasetContentDeliveryRule.Builder> getContentDeliveryRules() {
            List<DatasetContentDeliveryRule.Builder> result = DatasetContentDeliveryRulesCopier
                    .copyToBuilder(this.contentDeliveryRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContentDeliveryRules(Collection<DatasetContentDeliveryRule.BuilderImpl> contentDeliveryRules) {
            this.contentDeliveryRules = DatasetContentDeliveryRulesCopier.copyFromBuilder(contentDeliveryRules);
        }

        @Override
        @Transient
        public final Builder contentDeliveryRules(Collection<DatasetContentDeliveryRule> contentDeliveryRules) {
            this.contentDeliveryRules = DatasetContentDeliveryRulesCopier.copy(contentDeliveryRules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder contentDeliveryRules(DatasetContentDeliveryRule... contentDeliveryRules) {
            contentDeliveryRules(Arrays.asList(contentDeliveryRules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder contentDeliveryRules(Consumer<DatasetContentDeliveryRule.Builder>... contentDeliveryRules) {
            contentDeliveryRules(Stream.of(contentDeliveryRules)
                    .map(c -> DatasetContentDeliveryRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return retentionPeriod != null ? retentionPeriod.toBuilder() : null;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        @Override
        @Transient
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final VersioningConfiguration.Builder getVersioningConfiguration() {
            return versioningConfiguration != null ? versioningConfiguration.toBuilder() : null;
        }

        public final void setVersioningConfiguration(VersioningConfiguration.BuilderImpl versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration != null ? versioningConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder versioningConfiguration(VersioningConfiguration versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration;
            return this;
        }

        public final List<LateDataRule.Builder> getLateDataRules() {
            List<LateDataRule.Builder> result = LateDataRulesCopier.copyToBuilder(this.lateDataRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLateDataRules(Collection<LateDataRule.BuilderImpl> lateDataRules) {
            this.lateDataRules = LateDataRulesCopier.copyFromBuilder(lateDataRules);
        }

        @Override
        @Transient
        public final Builder lateDataRules(Collection<LateDataRule> lateDataRules) {
            this.lateDataRules = LateDataRulesCopier.copy(lateDataRules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lateDataRules(LateDataRule... lateDataRules) {
            lateDataRules(Arrays.asList(lateDataRules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lateDataRules(Consumer<LateDataRule.Builder>... lateDataRules) {
            lateDataRules(Stream.of(lateDataRules).map(c -> LateDataRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDatasetRequest build() {
            return new UpdateDatasetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
