/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the versioning of dataset contents.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VersioningConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VersioningConfiguration.Builder, VersioningConfiguration> {
    private static final SdkField<Boolean> UNLIMITED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("unlimited").getter(getter(VersioningConfiguration::unlimited)).setter(setter(Builder::unlimited))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unlimited").build()).build();

    private static final SdkField<Integer> MAX_VERSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxVersions").getter(getter(VersioningConfiguration::maxVersions)).setter(setter(Builder::maxVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxVersions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNLIMITED_FIELD,
            MAX_VERSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean unlimited;

    private final Integer maxVersions;

    private VersioningConfiguration(BuilderImpl builder) {
        this.unlimited = builder.unlimited;
        this.maxVersions = builder.maxVersions;
    }

    /**
     * <p>
     * If true, unlimited versions of dataset contents are kept.
     * </p>
     * 
     * @return If true, unlimited versions of dataset contents are kept.
     */
    public final Boolean unlimited() {
        return unlimited;
    }

    /**
     * <p>
     * How many versions of dataset contents are kept. The <code>unlimited</code> parameter must be <code>false</code>.
     * </p>
     * 
     * @return How many versions of dataset contents are kept. The <code>unlimited</code> parameter must be
     *         <code>false</code>.
     */
    public final Integer maxVersions() {
        return maxVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unlimited());
        hashCode = 31 * hashCode + Objects.hashCode(maxVersions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersioningConfiguration)) {
            return false;
        }
        VersioningConfiguration other = (VersioningConfiguration) obj;
        return Objects.equals(unlimited(), other.unlimited()) && Objects.equals(maxVersions(), other.maxVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VersioningConfiguration").add("Unlimited", unlimited()).add("MaxVersions", maxVersions())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "unlimited":
            return Optional.ofNullable(clazz.cast(unlimited()));
        case "maxVersions":
            return Optional.ofNullable(clazz.cast(maxVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VersioningConfiguration, T> g) {
        return obj -> g.apply((VersioningConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VersioningConfiguration> {
        /**
         * <p>
         * If true, unlimited versions of dataset contents are kept.
         * </p>
         * 
         * @param unlimited
         *        If true, unlimited versions of dataset contents are kept.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unlimited(Boolean unlimited);

        /**
         * <p>
         * How many versions of dataset contents are kept. The <code>unlimited</code> parameter must be
         * <code>false</code>.
         * </p>
         * 
         * @param maxVersions
         *        How many versions of dataset contents are kept. The <code>unlimited</code> parameter must be
         *        <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxVersions(Integer maxVersions);
    }

    static final class BuilderImpl implements Builder {
        private Boolean unlimited;

        private Integer maxVersions;

        private BuilderImpl() {
        }

        private BuilderImpl(VersioningConfiguration model) {
            unlimited(model.unlimited);
            maxVersions(model.maxVersions);
        }

        public final Boolean getUnlimited() {
            return unlimited;
        }

        public final void setUnlimited(Boolean unlimited) {
            this.unlimited = unlimited;
        }

        @Override
        @Transient
        public final Builder unlimited(Boolean unlimited) {
            this.unlimited = unlimited;
            return this;
        }

        public final Integer getMaxVersions() {
            return maxVersions;
        }

        public final void setMaxVersions(Integer maxVersions) {
            this.maxVersions = maxVersions;
        }

        @Override
        @Transient
        public final Builder maxVersions(Integer maxVersions) {
            this.maxVersions = maxVersions;
            return this;
        }

        @Override
        public VersioningConfiguration build() {
            return new VersioningConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
