/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChannelRequest extends IoTAnalyticsRequest implements
        ToCopyableBuilder<CreateChannelRequest.Builder, CreateChannelRequest> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelName").getter(getter(CreateChannelRequest::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()).build();

    private static final SdkField<ChannelStorage> CHANNEL_STORAGE_FIELD = SdkField
            .<ChannelStorage> builder(MarshallingType.SDK_POJO).memberName("channelStorage")
            .getter(getter(CreateChannelRequest::channelStorage)).setter(setter(Builder::channelStorage))
            .constructor(ChannelStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelStorage").build()).build();

    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField
            .<RetentionPeriod> builder(MarshallingType.SDK_POJO).memberName("retentionPeriod")
            .getter(getter(CreateChannelRequest::retentionPeriod)).setter(setter(Builder::retentionPeriod))
            .constructor(RetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateChannelRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD,
            CHANNEL_STORAGE_FIELD, RETENTION_PERIOD_FIELD, TAGS_FIELD));

    private final String channelName;

    private final ChannelStorage channelStorage;

    private final RetentionPeriod retentionPeriod;

    private final List<Tag> tags;

    private CreateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.channelName = builder.channelName;
        this.channelStorage = builder.channelStorage;
        this.retentionPeriod = builder.retentionPeriod;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the channel.
     * </p>
     * 
     * @return The name of the channel.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
     * <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You can't
     * change this storage option after the channel is created.
     * </p>
     * 
     * @return Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
     *         <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>.
     *         You can't change this storage option after the channel is created.
     */
    public final ChannelStorage channelStorage() {
        return channelStorage;
    }

    /**
     * <p>
     * How long, in days, message data is kept for the channel. When <code>customerManagedS3</code> storage is selected,
     * this parameter is ignored.
     * </p>
     * 
     * @return How long, in days, message data is kept for the channel. When <code>customerManagedS3</code> storage is
     *         selected, this parameter is ignored.
     */
    public final RetentionPeriod retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata which can be used to manage the channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata which can be used to manage the channel.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(channelStorage());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelRequest)) {
            return false;
        }
        CreateChannelRequest other = (CreateChannelRequest) obj;
        return Objects.equals(channelName(), other.channelName()) && Objects.equals(channelStorage(), other.channelStorage())
                && Objects.equals(retentionPeriod(), other.retentionPeriod()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChannelRequest").add("ChannelName", channelName()).add("ChannelStorage", channelStorage())
                .add("RetentionPeriod", retentionPeriod()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "channelStorage":
            return Optional.ofNullable(clazz.cast(channelStorage()));
        case "retentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelRequest, T> g) {
        return obj -> g.apply((CreateChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTAnalyticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateChannelRequest> {
        /**
         * <p>
         * The name of the channel.
         * </p>
         * 
         * @param channelName
         *        The name of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
         * <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You
         * can't change this storage option after the channel is created.
         * </p>
         * 
         * @param channelStorage
         *        Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
         *        <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>
         *        . You can't change this storage option after the channel is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelStorage(ChannelStorage channelStorage);

        /**
         * <p>
         * Where channel data is stored. You can choose one of <code>serviceManagedS3</code> or
         * <code>customerManagedS3</code> storage. If not specified, the default is <code>serviceManagedS3</code>. You
         * can't change this storage option after the channel is created.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChannelStorage.Builder} avoiding the need
         * to create one manually via {@link ChannelStorage#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChannelStorage.Builder#build()} is called immediately and its
         * result is passed to {@link #channelStorage(ChannelStorage)}.
         * 
         * @param channelStorage
         *        a consumer that will call methods on {@link ChannelStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelStorage(ChannelStorage)
         */
        default Builder channelStorage(Consumer<ChannelStorage.Builder> channelStorage) {
            return channelStorage(ChannelStorage.builder().applyMutation(channelStorage).build());
        }

        /**
         * <p>
         * How long, in days, message data is kept for the channel. When <code>customerManagedS3</code> storage is
         * selected, this parameter is ignored.
         * </p>
         * 
         * @param retentionPeriod
         *        How long, in days, message data is kept for the channel. When <code>customerManagedS3</code> storage
         *        is selected, this parameter is ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(RetentionPeriod retentionPeriod);

        /**
         * <p>
         * How long, in days, message data is kept for the channel. When <code>customerManagedS3</code> storage is
         * selected, this parameter is ignored.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetentionPeriod.Builder} avoiding the
         * need to create one manually via {@link RetentionPeriod#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetentionPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #retentionPeriod(RetentionPeriod)}.
         * 
         * @param retentionPeriod
         *        a consumer that will call methods on {@link RetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionPeriod(RetentionPeriod)
         */
        default Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return retentionPeriod(RetentionPeriod.builder().applyMutation(retentionPeriod).build());
        }

        /**
         * <p>
         * Metadata which can be used to manage the channel.
         * </p>
         * 
         * @param tags
         *        Metadata which can be used to manage the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata which can be used to manage the channel.
         * </p>
         * 
         * @param tags
         *        Metadata which can be used to manage the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata which can be used to manage the channel.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTAnalyticsRequest.BuilderImpl implements Builder {
        private String channelName;

        private ChannelStorage channelStorage;

        private RetentionPeriod retentionPeriod;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelRequest model) {
            super(model);
            channelName(model.channelName);
            channelStorage(model.channelStorage);
            retentionPeriod(model.retentionPeriod);
            tags(model.tags);
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final ChannelStorage.Builder getChannelStorage() {
            return channelStorage != null ? channelStorage.toBuilder() : null;
        }

        public final void setChannelStorage(ChannelStorage.BuilderImpl channelStorage) {
            this.channelStorage = channelStorage != null ? channelStorage.build() : null;
        }

        @Override
        public final Builder channelStorage(ChannelStorage channelStorage) {
            this.channelStorage = channelStorage;
            return this;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return retentionPeriod != null ? retentionPeriod.toBuilder() : null;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChannelRequest build() {
            return new CreateChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
