/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateChannelResponse extends IoTAnalyticsResponse implements
        ToCopyableBuilder<CreateChannelResponse.Builder, CreateChannelResponse> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelName").getter(getter(CreateChannelResponse::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()).build();

    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelArn").getter(getter(CreateChannelResponse::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelArn").build()).build();

    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField
            .<RetentionPeriod> builder(MarshallingType.SDK_POJO).memberName("retentionPeriod")
            .getter(getter(CreateChannelResponse::retentionPeriod)).setter(setter(Builder::retentionPeriod))
            .constructor(RetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD,
            CHANNEL_ARN_FIELD, RETENTION_PERIOD_FIELD));

    private final String channelName;

    private final String channelArn;

    private final RetentionPeriod retentionPeriod;

    private CreateChannelResponse(BuilderImpl builder) {
        super(builder);
        this.channelName = builder.channelName;
        this.channelArn = builder.channelArn;
        this.retentionPeriod = builder.retentionPeriod;
    }

    /**
     * <p>
     * The name of the channel.
     * </p>
     * 
     * @return The name of the channel.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The ARN of the channel.
     * </p>
     * 
     * @return The ARN of the channel.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * How long, in days, message data is kept for the channel.
     * </p>
     * 
     * @return How long, in days, message data is kept for the channel.
     */
    public final RetentionPeriod retentionPeriod() {
        return retentionPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelResponse)) {
            return false;
        }
        CreateChannelResponse other = (CreateChannelResponse) obj;
        return Objects.equals(channelName(), other.channelName()) && Objects.equals(channelArn(), other.channelArn())
                && Objects.equals(retentionPeriod(), other.retentionPeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateChannelResponse").add("ChannelName", channelName()).add("ChannelArn", channelArn())
                .add("RetentionPeriod", retentionPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "channelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "retentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelResponse, T> g) {
        return obj -> g.apply((CreateChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTAnalyticsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateChannelResponse> {
        /**
         * <p>
         * The name of the channel.
         * </p>
         * 
         * @param channelName
         *        The name of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The ARN of the channel.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * How long, in days, message data is kept for the channel.
         * </p>
         * 
         * @param retentionPeriod
         *        How long, in days, message data is kept for the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(RetentionPeriod retentionPeriod);

        /**
         * <p>
         * How long, in days, message data is kept for the channel.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetentionPeriod.Builder} avoiding the
         * need to create one manually via {@link RetentionPeriod#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetentionPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #retentionPeriod(RetentionPeriod)}.
         * 
         * @param retentionPeriod
         *        a consumer that will call methods on {@link RetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionPeriod(RetentionPeriod)
         */
        default Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return retentionPeriod(RetentionPeriod.builder().applyMutation(retentionPeriod).build());
        }
    }

    static final class BuilderImpl extends IoTAnalyticsResponse.BuilderImpl implements Builder {
        private String channelName;

        private String channelArn;

        private RetentionPeriod retentionPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelResponse model) {
            super(model);
            channelName(model.channelName);
            channelArn(model.channelArn);
            retentionPeriod(model.retentionPeriod);
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return retentionPeriod != null ? retentionPeriod.toBuilder() : null;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        @Override
        public CreateChannelResponse build() {
            return new CreateChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
