/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When dataset contents are created, they are delivered to destination specified here.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetContentDeliveryRule implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetContentDeliveryRule.Builder, DatasetContentDeliveryRule> {
    private static final SdkField<String> ENTRY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entryName").getter(getter(DatasetContentDeliveryRule::entryName)).setter(setter(Builder::entryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryName").build()).build();

    private static final SdkField<DatasetContentDeliveryDestination> DESTINATION_FIELD = SdkField
            .<DatasetContentDeliveryDestination> builder(MarshallingType.SDK_POJO).memberName("destination")
            .getter(getter(DatasetContentDeliveryRule::destination)).setter(setter(Builder::destination))
            .constructor(DatasetContentDeliveryDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_NAME_FIELD,
            DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String entryName;

    private final DatasetContentDeliveryDestination destination;

    private DatasetContentDeliveryRule(BuilderImpl builder) {
        this.entryName = builder.entryName;
        this.destination = builder.destination;
    }

    /**
     * <p>
     * The name of the dataset content delivery rules entry.
     * </p>
     * 
     * @return The name of the dataset content delivery rules entry.
     */
    public final String entryName() {
        return entryName;
    }

    /**
     * <p>
     * The destination to which dataset contents are delivered.
     * </p>
     * 
     * @return The destination to which dataset contents are delivered.
     */
    public final DatasetContentDeliveryDestination destination() {
        return destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entryName());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetContentDeliveryRule)) {
            return false;
        }
        DatasetContentDeliveryRule other = (DatasetContentDeliveryRule) obj;
        return Objects.equals(entryName(), other.entryName()) && Objects.equals(destination(), other.destination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetContentDeliveryRule").add("EntryName", entryName()).add("Destination", destination())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entryName":
            return Optional.ofNullable(clazz.cast(entryName()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetContentDeliveryRule, T> g) {
        return obj -> g.apply((DatasetContentDeliveryRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetContentDeliveryRule> {
        /**
         * <p>
         * The name of the dataset content delivery rules entry.
         * </p>
         * 
         * @param entryName
         *        The name of the dataset content delivery rules entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entryName(String entryName);

        /**
         * <p>
         * The destination to which dataset contents are delivered.
         * </p>
         * 
         * @param destination
         *        The destination to which dataset contents are delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(DatasetContentDeliveryDestination destination);

        /**
         * <p>
         * The destination to which dataset contents are delivered.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DatasetContentDeliveryDestination.Builder} avoiding the need to create one manually via
         * {@link DatasetContentDeliveryDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatasetContentDeliveryDestination.Builder#build()} is called
         * immediately and its result is passed to {@link #destination(DatasetContentDeliveryDestination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link DatasetContentDeliveryDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(DatasetContentDeliveryDestination)
         */
        default Builder destination(Consumer<DatasetContentDeliveryDestination.Builder> destination) {
            return destination(DatasetContentDeliveryDestination.builder().applyMutation(destination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String entryName;

        private DatasetContentDeliveryDestination destination;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetContentDeliveryRule model) {
            entryName(model.entryName);
            destination(model.destination);
        }

        public final String getEntryName() {
            return entryName;
        }

        public final void setEntryName(String entryName) {
            this.entryName = entryName;
        }

        @Override
        public final Builder entryName(String entryName) {
            this.entryName = entryName;
            return this;
        }

        public final DatasetContentDeliveryDestination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(DatasetContentDeliveryDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(DatasetContentDeliveryDestination destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public DatasetContentDeliveryRule build() {
            return new DatasetContentDeliveryRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
