/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of information about a dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetSummary implements SdkPojo, Serializable, ToCopyableBuilder<DatasetSummary.Builder, DatasetSummary> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetName").getter(getter(DatasetSummary::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DatasetSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(DatasetSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime").getter(getter(DatasetSummary::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final SdkField<List<DatasetTrigger>> TRIGGERS_FIELD = SdkField
            .<List<DatasetTrigger>> builder(MarshallingType.LIST)
            .memberName("triggers")
            .getter(getter(DatasetSummary::triggers))
            .setter(setter(Builder::triggers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatasetTrigger> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetTrigger::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DatasetActionSummary>> ACTIONS_FIELD = SdkField
            .<List<DatasetActionSummary>> builder(MarshallingType.LIST)
            .memberName("actions")
            .getter(getter(DatasetSummary::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DatasetActionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DatasetActionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD,
            STATUS_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, TRIGGERS_FIELD, ACTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String datasetName;

    private final String status;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private final List<DatasetTrigger> triggers;

    private final List<DatasetActionSummary> actions;

    private DatasetSummary(BuilderImpl builder) {
        this.datasetName = builder.datasetName;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.triggers = builder.triggers;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * The name of the dataset.
     * </p>
     * 
     * @return The name of the dataset.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The status of the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatasetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the dataset.
     * @see DatasetStatus
     */
    public final DatasetStatus status() {
        return DatasetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the dataset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatasetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the dataset.
     * @see DatasetStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time the dataset was created.
     * </p>
     * 
     * @return The time the dataset was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the dataset was updated.
     * </p>
     * 
     * @return The last time the dataset was updated.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Triggers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTriggers() {
        return triggers != null && !(triggers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of triggers. A trigger causes dataset content to be populated at a specified time interval or when another
     * dataset is populated. The list of triggers can be empty or contain up to five <code>DataSetTrigger</code> objects
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTriggers} method.
     * </p>
     * 
     * @return A list of triggers. A trigger causes dataset content to be populated at a specified time interval or when
     *         another dataset is populated. The list of triggers can be empty or contain up to five
     *         <code>DataSetTrigger</code> objects
     */
    public final List<DatasetTrigger> triggers() {
        return triggers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DataActionSummary</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return A list of <code>DataActionSummary</code> objects.
     */
    public final List<DatasetActionSummary> actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTriggers() ? triggers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetSummary)) {
            return false;
        }
        DatasetSummary other = (DatasetSummary) obj;
        return Objects.equals(datasetName(), other.datasetName()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime()) && hasTriggers() == other.hasTriggers()
                && Objects.equals(triggers(), other.triggers()) && hasActions() == other.hasActions()
                && Objects.equals(actions(), other.actions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetSummary").add("DatasetName", datasetName()).add("Status", statusAsString())
                .add("CreationTime", creationTime()).add("LastUpdateTime", lastUpdateTime())
                .add("Triggers", hasTriggers() ? triggers() : null).add("Actions", hasActions() ? actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "triggers":
            return Optional.ofNullable(clazz.cast(triggers()));
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetSummary, T> g) {
        return obj -> g.apply((DatasetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetSummary> {
        /**
         * <p>
         * The name of the dataset.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The status of the dataset.
         * </p>
         * 
         * @param status
         *        The status of the dataset.
         * @see DatasetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the dataset.
         * </p>
         * 
         * @param status
         *        The status of the dataset.
         * @see DatasetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatasetStatus
         */
        Builder status(DatasetStatus status);

        /**
         * <p>
         * The time the dataset was created.
         * </p>
         * 
         * @param creationTime
         *        The time the dataset was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the dataset was updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The last time the dataset was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * A list of triggers. A trigger causes dataset content to be populated at a specified time interval or when
         * another dataset is populated. The list of triggers can be empty or contain up to five
         * <code>DataSetTrigger</code> objects
         * </p>
         * 
         * @param triggers
         *        A list of triggers. A trigger causes dataset content to be populated at a specified time interval or
         *        when another dataset is populated. The list of triggers can be empty or contain up to five
         *        <code>DataSetTrigger</code> objects
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(Collection<DatasetTrigger> triggers);

        /**
         * <p>
         * A list of triggers. A trigger causes dataset content to be populated at a specified time interval or when
         * another dataset is populated. The list of triggers can be empty or contain up to five
         * <code>DataSetTrigger</code> objects
         * </p>
         * 
         * @param triggers
         *        A list of triggers. A trigger causes dataset content to be populated at a specified time interval or
         *        when another dataset is populated. The list of triggers can be empty or contain up to five
         *        <code>DataSetTrigger</code> objects
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(DatasetTrigger... triggers);

        /**
         * <p>
         * A list of triggers. A trigger causes dataset content to be populated at a specified time interval or when
         * another dataset is populated. The list of triggers can be empty or contain up to five
         * <code>DataSetTrigger</code> objects
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DatasetTrigger>.Builder} avoiding
         * the need to create one manually via {@link List<DatasetTrigger>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DatasetTrigger>.Builder#build()} is called immediately and
         * its result is passed to {@link #triggers(List<DatasetTrigger>)}.
         * 
         * @param triggers
         *        a consumer that will call methods on {@link List<DatasetTrigger>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggers(List<DatasetTrigger>)
         */
        Builder triggers(Consumer<DatasetTrigger.Builder>... triggers);

        /**
         * <p>
         * A list of <code>DataActionSummary</code> objects.
         * </p>
         * 
         * @param actions
         *        A list of <code>DataActionSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<DatasetActionSummary> actions);

        /**
         * <p>
         * A list of <code>DataActionSummary</code> objects.
         * </p>
         * 
         * @param actions
         *        A list of <code>DataActionSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(DatasetActionSummary... actions);

        /**
         * <p>
         * A list of <code>DataActionSummary</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<DatasetActionSummary>.Builder}
         * avoiding the need to create one manually via {@link List<DatasetActionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DatasetActionSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #actions(List<DatasetActionSummary>)}.
         * 
         * @param actions
         *        a consumer that will call methods on {@link List<DatasetActionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(List<DatasetActionSummary>)
         */
        Builder actions(Consumer<DatasetActionSummary.Builder>... actions);
    }

    static final class BuilderImpl implements Builder {
        private String datasetName;

        private String status;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private List<DatasetTrigger> triggers = DefaultSdkAutoConstructList.getInstance();

        private List<DatasetActionSummary> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetSummary model) {
            datasetName(model.datasetName);
            status(model.status);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
            triggers(model.triggers);
            actions(model.actions);
        }

        public final String getDatasetName() {
            return datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DatasetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final List<DatasetTrigger.Builder> getTriggers() {
            List<DatasetTrigger.Builder> result = DatasetTriggersCopier.copyToBuilder(this.triggers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggers(Collection<DatasetTrigger.BuilderImpl> triggers) {
            this.triggers = DatasetTriggersCopier.copyFromBuilder(triggers);
        }

        @Override
        public final Builder triggers(Collection<DatasetTrigger> triggers) {
            this.triggers = DatasetTriggersCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(DatasetTrigger... triggers) {
            triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Consumer<DatasetTrigger.Builder>... triggers) {
            triggers(Stream.of(triggers).map(c -> DatasetTrigger.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DatasetActionSummary.Builder> getActions() {
            List<DatasetActionSummary.Builder> result = DatasetActionSummariesCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<DatasetActionSummary.BuilderImpl> actions) {
            this.actions = DatasetActionSummariesCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<DatasetActionSummary> actions) {
            this.actions = DatasetActionSummariesCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(DatasetActionSummary... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<DatasetActionSummary.Builder>... actions) {
            actions(Stream.of(actions).map(c -> DatasetActionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DatasetSummary build() {
            return new DatasetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
