/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDatasetResponse extends IoTAnalyticsResponse implements
        ToCopyableBuilder<DescribeDatasetResponse.Builder, DescribeDatasetResponse> {
    private static final SdkField<Dataset> DATASET_FIELD = SdkField.<Dataset> builder(MarshallingType.SDK_POJO)
            .memberName("dataset").getter(getter(DescribeDatasetResponse::dataset)).setter(setter(Builder::dataset))
            .constructor(Dataset::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_FIELD));

    private final Dataset dataset;

    private DescribeDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.dataset = builder.dataset;
    }

    /**
     * <p>
     * An object that contains information about the dataset.
     * </p>
     * 
     * @return An object that contains information about the dataset.
     */
    public final Dataset dataset() {
        return dataset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetResponse)) {
            return false;
        }
        DescribeDatasetResponse other = (DescribeDatasetResponse) obj;
        return Objects.equals(dataset(), other.dataset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDatasetResponse").add("Dataset", dataset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataset":
            return Optional.ofNullable(clazz.cast(dataset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetResponse, T> g) {
        return obj -> g.apply((DescribeDatasetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTAnalyticsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDatasetResponse> {
        /**
         * <p>
         * An object that contains information about the dataset.
         * </p>
         * 
         * @param dataset
         *        An object that contains information about the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataset(Dataset dataset);

        /**
         * <p>
         * An object that contains information about the dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link Dataset.Builder} avoiding the need to
         * create one manually via {@link Dataset#builder()}.
         *
         * When the {@link Consumer} completes, {@link Dataset.Builder#build()} is called immediately and its result is
         * passed to {@link #dataset(Dataset)}.
         * 
         * @param dataset
         *        a consumer that will call methods on {@link Dataset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataset(Dataset)
         */
        default Builder dataset(Consumer<Dataset.Builder> dataset) {
            return dataset(Dataset.builder().applyMutation(dataset).build());
        }
    }

    static final class BuilderImpl extends IoTAnalyticsResponse.BuilderImpl implements Builder {
        private Dataset dataset;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetResponse model) {
            super(model);
            dataset(model.dataset);
        }

        public final Dataset.Builder getDataset() {
            return dataset != null ? dataset.toBuilder() : null;
        }

        public final void setDataset(Dataset.BuilderImpl dataset) {
            this.dataset = dataset != null ? dataset.build() : null;
        }

        @Override
        public final Builder dataset(Dataset dataset) {
            this.dataset = dataset;
            return this;
        }

        @Override
        public DescribeDatasetResponse build() {
            return new DescribeDatasetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
